<?php
session_start();
require 'functions.php'; // Ensure this file contains the necessary functions (e.g., checkLogin, checkPermissionReport, connect, checkSQL)

// Connect to the database
$db_link = connect();
if (!$db_link) {
    die('Database connection failed.');
}

// Set the default timezone to East Africa Time (EAT)
date_default_timezone_set('Africa/Nairobi');

// Use the Authorization header directly
$authorizationHeader = 'Basic TE1YR0NMOnY3dXZubmhmaGFxenB5'; // Replace with your actual Authorization header

// Fetch all SMS records with status 'Submitted' or 'Pending'
$query = "SELECT id FROM sms_messages WHERE status IN ('submitted', 'pending', 'sent')";
$result = mysqli_query($db_link, $query);

// Check if the query executed successfully
if (!$result) {
    die('Database query failed.');
}

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $smsId = $row['id'];

        // Call the Delivery API to check the status
        $apiUrl = "https://api.sms-gate.app/3rdparty/v1/messages/" . $smsId;

        // Use cURL to call the API
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'authorization: ' . $authorizationHeader // Use the Authorization header directly
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

        if ($response !== false) {
            // Decode the JSON response
            $responseData = json_decode($response, true);

            // Check if the response contains the expected data
            if (isset($responseData['state'])) {
                $status = $responseData['state']; // Delivery status (e.g., "Delivered", "Pending", etc.)
                $deliveredTime = ($status == 'Delivered') ? date('Y-m-d H:i:s') : NULL;

                // Update the database
                $updateQuery = "UPDATE sms_messages SET status = ?, delivered_time = ? WHERE id = ? AND id = ?";
                $stmt = mysqli_prepare($db_link, $updateQuery);
                mysqli_stmt_bind_param($stmt, "ssis", $status, $deliveredTime, $smsId, $smsId);

                mysqli_stmt_execute($stmt);

                // Close the prepared statement
                mysqli_stmt_close($stmt);
            }
        }
    }
}

// Close the database connection
mysqli_close($db_link);
?>