<?php
session_start();
require 'functions.php';
checkLogin();
$db_link = connect();
getCustID($db_link);

unset($_SESSION['interest_sum'], $_SESSION['balance']);

// Generate timestamp
$timestamp = time();

// Calculate Balance on Savings account
$sav_balance = getSavingsBalance($db_link, $_SESSION['cust_id']);
$sav_fixed = getSavingsFixed($db_link, $_SESSION['cust_id']);

// UPDATE-Button
if (isset($_POST['update'])) {
    // Sanitize user input
    $cust_no = sanitize($db_link, $_POST['cust_no']);
    $cust_name = sanitize($db_link, $_POST['cust_name']);
    $cust_dob = strtotime(sanitize($db_link, $_POST['cust_dob']));
    $custsex_id = sanitize($db_link, $_POST['custsex_id']);
    $cust_address = sanitize($db_link, $_POST['cust_address']);
    $cust_phone = sanitize($db_link, $_POST['cust_phone']);
    $cust_email = sanitize($db_link, $_POST['cust_email']);
    $cust_occup = sanitize($db_link, $_POST['cust_occup']);
    $custmarried_id = sanitize($db_link, $_POST['custmarried_id']);
    $cust_heir = sanitize($db_link, $_POST['cust_heir']);
    $cust_heirrel = sanitize($db_link, $_POST['cust_heirrel']);
    if ($cust_lengthres == 0 OR $cust_lengthres == NULL) $cust_lengthres = NULL;
    $custsick_id = sanitize($db_link, $_POST['custsick_id']);
    $cust_active = sanitize($db_link, $_POST['cust_active']);
    $timestamp = time();

    // Update CUSTOMER
    $sql_update = "UPDATE customer SET cust_no = '$cust_no', cust_name = '$cust_name', cust_dob = $cust_dob, custsex_id = $custsex_id, cust_address = '$cust_address', cust_phone = '$cust_phone', cust_email = '$cust_email', cust_occup = '$cust_occup', custmarried_id = $custmarried_id, cust_heir = '$cust_heir', cust_heirrel = '$cust_heirrel', custsick_id = $custsick_id, cust_active = '$cust_active', cust_lastupd = $timestamp, user_id = $_SESSION[log_id] WHERE cust_id = $_SESSION[cust_id]";
    $query_update = mysqli_query($db_link, $sql_update);
    checkSQL($db_link, $query_update);
    header('Location: customer.php?cust='.$_SESSION['cust_id']);
}

// Get current customer's details
$result_cust = getCustomer($db_link, $_SESSION['cust_id']);

// Error-Message, if customer is not found
if ($result_cust['cust_id'] == '') {
    echo '<script>
            alert(\'Customer not found in database.\');
            window.location = "cust_search.php";
          </script>';
}

// Select Marital Status from custmarried for dropdown-menu
$sql_mstat = "SELECT * FROM custmarried";
$query_mstat = mysqli_query($db_link, $sql_mstat);
checkSQL($db_link, $query_mstat);

// Select Sicknesses from custsick for dropdown-menu
$sql_sick = "SELECT * FROM custsick";
$query_sick = mysqli_query($db_link, $sql_sick);
checkSQL($db_link, $query_sick);

// Select Sexes from custsex for dropdown-menu
$sql_sex = "SELECT * FROM custsex";
$query_sex = mysqli_query($db_link, $sql_sex);
checkSQL($db_link, $query_sex);

// Select Shares from SHARES
$sql_sha = "SELECT * FROM shares WHERE cust_id = '$_SESSION[cust_id]'";
$query_sha = mysqli_query($db_link, $sql_sha);
checkSQL($db_link, $query_sha);
$share_amount = 0;
$share_value = 0;
while ($row_shares = mysqli_fetch_assoc($query_sha)) {
    $share_amount = $share_amount + $row_shares['share_amount'];
    $share_value = $share_value + $row_shares['share_value'];
}

// Select Shares from Incomes
$sql_cust_income = "SELECT * FROM incomes WHERE cust_id = '$_SESSION[cust_id]' AND inctype_id = 3";
$query_cust_income = mysqli_query($db_link, $sql_cust_income);
checkSQL($db_link, $query_cust_income);
$cust_income_amount = 0;
while ($row_shares = mysqli_fetch_assoc($query_cust_income)) {
    $cust_income_amount = $cust_income_amount + $row_shares['inc_amount'];
}

// Select the five most recent savings transactions for display
$sql_sav = "SELECT * FROM savings, savtype WHERE savings.savtype_id = savtype.savtype_id AND cust_id = '$_SESSION[cust_id]' ORDER BY sav_date DESC, sav_id DESC LIMIT 5";
$query_sav = mysqli_query($db_link, $sql_sav);
checkSQL($db_link, $query_sav);

// Fetch customer's phone number
$cust_phone = $result_cust['cust_phone']; // Assuming $result_cust contains customer details

// Normalize the customer's phone number for comparison
$cust_phone_normalized = preg_replace('/[^0-9]/', '', $cust_phone); // Remove non-numeric characters

// Fetch the last 5 inbound messages for the customer
$sql_inbound_messages = "SELECT `id`, `type`, `phone_number`, `message`, `timestamp`, `delivered_time`, `status`, `direction` 
                         FROM `sms_messages` 
                         WHERE REPLACE(phone_number, '+', '') = '$cust_phone_normalized' 
                         AND `type`='inbound'
                         ORDER BY `timestamp` DESC 
                         LIMIT 5"; // Fetch only the last 5 inbound messages
$query_inbound_messages = mysqli_query($db_link, $sql_inbound_messages);
checkSQL($db_link, $query_inbound_messages);

// Fetch the last 5 outbound messages for the customer
$sql_outbound_messages = "SELECT `id`, `type`, `phone_number`, `message`, `timestamp`, `delivered_time`, `status`, `direction` 
                          FROM `sms_messages` 
                          WHERE REPLACE(phone_number, '+', '') = '$cust_phone_normalized' 
                          AND `type`='outbound'
                          ORDER BY `timestamp` DESC 
                          LIMIT 5"; // Fetch only the last 5 outbound messages
$query_outbound_messages = mysqli_query($db_link, $sql_outbound_messages);
checkSQL($db_link, $query_outbound_messages);
?>

<html>
    <?php includeHead('Customer', 0) ?>
    <script>
        function validate(form) {
            fail = validateName(form.cust_name.value)
            fail += validateDob(form.cust_dob.value)
            fail += validateAddress(form.cust_address.value)
            fail += validatePhone(form.cust_phone.value)
            fail += validateEmail(form.cust_email.value)
            if (fail == "") return true
            else { alert(fail); return false }
        }

        function validateSubscr(form) {
            fail = validateDate(form.subscr_date.value)
            fail += validateReceipt(form.subscr_receipt.value)
            if (document.getElementById('subscr_from_sav').checked) {
                fail += validateOverdraft(<?php echo $_SESSION['fee_subscr']; ?>, <?php echo $sav_balance; ?>, 0, <?php echo $_SESSION['set_msb']; ?>, <?php echo $sav_fixed; ?>)
            }
            if (fail == "") return true
            else { alert(fail); return false }
        }

        function setVisibility(id, visibility) {
            document.getElementById(id).style.display = visibility;
        }
    </script>
    <script src="functions_validate.js"></script>
</head>

<body>
    <!-- MENU -->
    <?php includeMenu(2); ?>
    <div id="menu_main">
        <a href="cust_search.php">Search</a>
        <?php
        if ($result_cust['cust_active'] == 1 && ($timestamp - $result_cust['cust_since']) > convertMonths($_SESSION['set_minmemb'])) {
            echo '<a href="loan_new.php?cust=' . $_SESSION['cust_id'] . '">New Loan</a>';
        }
        ?>
        <?php
        if ($_SESSION['log_delete'] == '1') {
            if ($result_cust['cust_active'] == 1) {
                echo '
                <a href="acc_sav_depos.php?cust=' . $_SESSION['cust_id'] . '">Deposit</a>
                <a href="acc_sav_withd.php?cust=' . $_SESSION['cust_id'] . '">Withdrawal</a>
                <a href="acc_share_buy.php?cust=' . $_SESSION['cust_id'] . '">Share Buy</a>
                <a href="acc_share_sale.php?cust=' . $_SESSION['cust_id'] . '">Share Sale</a>';
            }
            if ($result_cust['cust_active'] == 1 && ($timestamp - $result_cust['cust_since']) > convertMonths($_SESSION['set_minmemb'])) {
                echo '<a href="loan_new.php?cust=' . $_SESSION['cust_id'] . '">New Loan</a>';
            }
        }
        ?>
        <?php if ($_SESSION['log_report'] !== '1') {
            echo '<a href="cust_new.php">New Customer</a>';
        } ?>
        <a href="cust_act.php">Active Cust.</a>
        <a href="cust_inact.php">Inactive Cust.</a>
    </div>

    <!-- LEFT SIDE: Customer Details -->
    <div class="content_left" style="width:60%;">
        <!-- HEADING -->
        <p class="heading" style="margin-bottom:.3em;">
            <?php echo $result_cust['cust_name'] . ' (' . $result_cust['cust_no'] . ')'; ?>
        </p>

        <form action="customer.php" method="post" onSubmit="return validate(this)">
            <table id="tb_fields" style="border-spacing:0.1em 1.25em;">
                <colgroup>
                    <col width="9%"/>
                    <col width="25%"/>
                    <col width="8%"/>
                    <col width="25%"/>
                    <col width="8%"/>
                    <col width="25%"/>
                </colgroup>
                <?php
                echo '<tr>
                        <td rowspan="4" colspan="2" style="text-align:center; vertical-align:top;">
                        <a href="cust_new_pic.php?from=customer">';
                if (isset($result_cust['cust_pic'])) {
                    echo '<img src="' . $result_cust['cust_pic'] . '" title="Customer\'s picture">';
                } else {
                    if ($result_cust['custsex_id'] == 2) echo '<img src="ico/custpic_f.png" title="Upload new picture" />';
                    else echo '<img src="ico/custpic_m.png" title="Upload new picture" />';
                }
                echo '  </a>
                        </td>
                        <td>Cust No:</td>
                        <td><input type="text" name="cust_no" value="' . $result_cust['cust_no'] . '" tabindex="1" /></td>
                        <td>Occupation:</td>
                        <td><input type="text" name="cust_occup" value="' . $result_cust['cust_occup'] . '" tabindex="8"/></td>
                    </tr>';
                echo '<tr>
                        <td>Name:</td>
                        <td><input type="text" name="cust_name" value="' . $result_cust['cust_name'] . '" tabindex="2" /></td>
                        <td>Marital Status:</td>
                        <td>
                            <select name="custmarried_id" size="1" tabindex="9">';
                while ($row_mstat = mysqli_fetch_assoc($query_mstat)) {
                    if ($row_mstat['custmarried_id'] == $result_cust['custmarried_id']) {
                        echo '<option selected value="' . $row_mstat['custmarried_id'] . '">' . $row_mstat['custmarried_status'] . '</option>';
                    } else {
                        echo '<option value="' . $row_mstat['custmarried_id'] . '">' . $row_mstat['custmarried_status'] . '</option>';
                    }
                }
                echo '  </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Gender:</td>
                        <td>
                            <select name="custsex_id" size="1" tabindex="3">';
                while ($row_sex = mysqli_fetch_assoc($query_sex)) {
                    if ($row_sex['custsex_id'] == $result_cust['custsex_id']) {
                        echo '<option selected value="' . $row_sex['custsex_id'] . '">' . $row_sex['custsex_name'] . '</option>';
                    } else {
                        echo '<option value="' . $row_sex['custsex_id'] . '">' . $row_sex['custsex_name'] . '</option>';
                    }
                }
                echo '</select>
                        </td>
                        <td>Representative:</td>
                        <td><input type="text" name="cust_heir" value="' . $result_cust['cust_heir'] . '" tabindex="10" /></td>
                    </tr>
                    <tr>
                        <td>DoB:</td>
                        <td><input type="text" id="datepicker" name="cust_dob" value="' . date("d.m.Y", $result_cust['cust_dob']) . '" placeholder="DD.MM.YYYY" tabindex="4" /></td>
                        <td>Relation:</td>
                        <td><input type="text" name="cust_heirrel" value="' . $result_cust['cust_heirrel'] . '" tabindex="11" /></td>
                    </tr>
                    <tr>';
                if ($_SESSION['fee_subscr'] > 0) {
                    echo '<td>Subscrip. expires:</td>
                          <td><input type="text" name="cust_lastsub" value="' . date("d.m.Y", $result_cust['cust_lastsub'] + 31536000) . '" disabled="disabled"/></td>';
                } else {
                    echo '<td></td><td></td>';
                }
                echo '<td>Address:</td>
                        <td><input type="text" name="cust_address" value="' . $result_cust['cust_address'] . '" placeholder="Place of Residence" tabindex="5" /></td>
                        <td>Sickness:</td>
                        <td>
                            <select name="custsick_id" size="1" tabindex="12">';
                while ($row_sick = mysqli_fetch_assoc($query_sick)) {
                    if ($row_sick['custsick_id'] == $result_cust['custsick_id']) {
                        echo '<option selected value="' . $row_sick['custsick_id'] . '">' . $row_sick['custsick_name'] . '</option>';
                    } else {
                        echo '<option value="' . $row_sick['custsick_id'] . '">' . $row_sick['custsick_name'] . '</option>';
                    }
                }
                echo '</select>
                        </td>
                    </tr>';
                echo '<tr>
                        <td>Member since:</td>
                        <td><input type="text" name="cust_since" value="' . date("d.m.Y", $result_cust['cust_since']) . '" disabled="disabled" /></td>
                        <td>Phone No:</td>
                        <td><input type="text" name="cust_phone" value="' . $result_cust['cust_phone'] . '" tabindex="6" /></td>
                        <td>Active:</td>
                        <td><input type="checkbox" name="cust_active" value="1" tabindex="13"';
                if ($result_cust['cust_active'] == 1) echo ' checked="checked"';
                echo ' />
                        </td>
                    </tr>
                    <tr>
                        <td>Updated<br/>on / by:</td>
                        <td><input type="text" disabled="diabled" value="' . date("d.m.Y", $result_cust['cust_lastupd']) . ' / ' . $result_cust['user_name'] . '" /></td>
                        <td>E-Mail:</td>
                        <td><input type="text" name="cust_email" value="' . $result_cust['cust_email'] . '" placeholder="abc@xyz.com" tabindex="7" /></td>
                        <td></td>';
                if ($_SESSION['log_delete'] == '1') {
                    echo '<td><input type="submit" name="update" value="Save Changes" tabindex="14" /></td>';
                }
                echo '</tr>';
                ?>
            </table>
        </form>

        <!-- MIDDLE PART: Renew Subscription -->
        <?php if ($_SESSION['fee_subscr'] > 0) include 'modules/mod_subscr.php'; ?>
    </div>

    <!-- RIGHT SIDE: Account Details -->
    <div class="content_right" style="width:40%;">
        <!-- TABLE 1: Savings Account -->
        <table id="tb_table">
            <colgroup>
                <col width="20%">
                <col width="30%">
                <col width="30%">
                <col width="20%">
            </colgroup>
            <tr>
                <th class="title" colspan="4">
                    <?php
                    if ($result_cust['cust_active'] == 1) {
                        echo '<a href="acc_sav_depos.php?cust=' . $_SESSION['cust_id'] . '">Social Fund</a> (Recent Transactions)';
                    } else {
                        echo 'Savings Account (Recent Transactions)';
                    }
                    ?>
                </th>
            </tr>
            <tr>
                <th>Date</th>
                <th>Transaction Type</th>
                <th>Amount</th>
                <th>Receipt/Slip</th>
            </tr>
            <?php
            while ($row_sav = mysqli_fetch_assoc($query_sav)) {
                echo '<tr>
                        <td>' . date("d.m.Y", $row_sav['sav_date']) . '</td>
                        <td>' . $row_sav['savtype_type'] . '</td>
                        <td>' . number_format($row_sav['sav_amount']) . ' ' . $_SESSION['set_cur'] . '</td>';
                if ($row_sav['savtype_id'] == 2) {
                    echo '<td>S ' . $row_sav['sav_slip'] . '</td>';
                } else {
                    echo '<td>R ' . $row_sav['sav_receipt'] . '</td>';
                }
                echo '</tr>';
            }
            echo '<tr class="balance">
                    <td colspan="4">Balance: ' . number_format($sav_balance) . ' ' . $_SESSION['set_cur'] . '</td>
                  </tr>';
            ?>
        </table>

        <!-- TABLE 2: Loans Account with Pagination -->
        <?php
        // Number of loans to display per page
        $loansPerPage = 10;

        // Get the current page number from the URL (default to page 1)
        $page = isset($_GET['loan_page']) ? (int)$_GET['loan_page'] : 1;
        if ($page < 1) {
            $page = 1;
        }

        // Calculate the offset for the SQL query
        $offset = ($page - 1) * $loansPerPage;

        // Fetch total number of loans for pagination
        $sql_total_loans = "SELECT COUNT(*) AS total FROM loans WHERE cust_id = '$_SESSION[cust_id]'";
        $query_total_loans = mysqli_query($db_link, $sql_total_loans);
        $totalLoans = mysqli_fetch_assoc($query_total_loans)['total'];
        $totalPages = ceil($totalLoans / $loansPerPage);

        // Fetch loans for the current page, sorted by status (approved -> pending -> cleared -> others)
        $sql_loans = "SELECT * FROM loans, loanstatus 
                      WHERE loans.loanstatus_id = loanstatus.loanstatus_id 
                      AND cust_id = '$_SESSION[cust_id]' 
                      ORDER BY 
                        CASE 
                          WHEN loans.loanstatus_id = 2 THEN 1  -- Approved loans first
                          WHEN loans.loanstatus_id = 1 THEN 2  -- Pending loans next
                          WHEN loans.loanstatus_id = 3 THEN 3  -- Cleared loans next
                          ELSE 4  -- All other loans
                        END, 
                        loan_no 
                      LIMIT $loansPerPage OFFSET $offset";
        $query_loans = mysqli_query($db_link, $sql_loans);
        checkSQL($db_link, $query_loans);
        ?>
        <table id="tb_table">
            <colgroup>
                <col width="20%">
                <col width="20%">
                <col width="20%">
                <col width="20%">
                <col width="20%">
            </colgroup>
            <tr>
                <th class="title" colspan="5">Loans Account</th>
            </tr>
            <tr>
                <th>Loan No.</th>
                <th>Status</th>
                <th>Amount</th>
                <th>Balance</th>
                <th>Next Rate</th>
            </tr>
            <?php
            while ($row_loan = mysqli_fetch_assoc($query_loans)) {
                // Select last unpaid Due Date from LTRANS
                $sql_ltrans = "SELECT MIN(ltrans_due) FROM ltrans, loans 
                               WHERE ltrans.loan_id = loans.loan_id 
                               AND loans.loanstatus_id = '2' 
                               AND loans.loan_id = '$row_loan[loan_id]' 
                               AND ltrans_due IS NOT NULL 
                               AND ltrans_date IS NULL";
                $query_ltrans = mysqli_query($db_link, $sql_ltrans);
                checkSQL($db_link, $query_ltrans);
                $next_due = mysqli_fetch_assoc($query_ltrans);

                // Get loan balances
                $loan_balances = getLoanBalance($db_link, $row_loan['loan_id']);

                echo '<tr>
                        <td><a href="loan.php?lid=' . $row_loan['loan_id'] . '">' . $row_loan['loan_no'] . '</a></td>
                        <td>' . $row_loan['loanstatus_status'] . '</td>';
                if ($row_loan['loan_issued'] == 1) {
                    echo '<td>' . number_format($loan_balances['pdue'] + $loan_balances['idue']) . '</td>
                          <td>' . number_format($loan_balances['balance']) . '</td>';
                } else {
                    echo '<td>' . number_format($row_loan['loan_principal']) . '</td>
                          <td>N/A</td>';
                }
                if ($row_loan['loanstatus_id'] == 2 && isset($next_due['MIN(ltrans_due)'])) {
                    echo '<td';
                    if ($next_due['MIN(ltrans_due)'] < time()) echo ' class="warn"';
                    echo '>' . date("d.m.Y", $next_due['MIN(ltrans_due)']) . '</td>';
                } else {
                    echo '<td>N/A</td>';
                }
                echo '</tr>';
            }
            ?>
        </table>

        <!-- Pagination Controls -->
        <div class="pagination">
            <?php if ($page > 1): ?>
                <a href="?cust=<?php echo $_SESSION['cust_id']; ?>&loan_page=<?php echo $page - 1; ?>">Previous</a>
            <?php endif; ?>

            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <a href="?cust=<?php echo $_SESSION['cust_id']; ?>&loan_page=<?php echo $i; ?>" 
                   <?php echo $i === $page ? 'class="active"' : ''; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?cust=<?php echo $_SESSION['cust_id']; ?>&loan_page=<?php echo $page + 1; ?>">Next</a>
            <?php endif; ?>
        </div>

        <!-- TABLE 3: Share Account -->
        <table id="tb_table">
            <tr>
                <th class="title" colspan="2">
                    <?php
                    if ($result_cust['cust_active'] == 1) {
                        echo '<a href="acc_share_buy.php?cust=' . $_SESSION['cust_id'] . '">Share Account</a>';
                    } else {
                        echo 'Share Account';
                    }
                    ?>
                </th>
            </tr>
            <tr>
                <th>Number of Shares</th>
                <th>Value of Shares</th>
            </tr>
            <tr>
                <td><?php echo $share_amount; ?></td>
                <td><?php echo number_format($share_value) . ' ' . $_SESSION['set_cur']; ?></td>
            </tr>
        </table>

        <!-- TABLE 4: Loan Factor -->
        <table id="tb_table">
            <tr>
                <th class="title" colspan="2">
                    <?php
                    if ($result_cust['cust_active'] == 1) {
                        echo '<a href="acc_share_buy.php?cust=' . $_SESSION['cust_id'] . '">Loan Factor</a>';
                    } else {
                        echo 'Share Account';
                    }
                    ?>
                </th>
            </tr>
            <tr>
                <th>Number of Shares</th>
                <th>Loan Applicable</th>
            </tr>
            <tr>
                <td><?php echo $share_amount; ?></td>
                <td><?php echo number_format($share_value * 2) . ' ' . $_SESSION['set_cur']; ?></td>
            </tr>
        </table>

        <!-- TABLE 5: Fines Paid -->
        <table id="tb_table">
            <colgroup>
                <col width="20%">
                <col width="20%">
            </colgroup>
            <tr>
                <th class="title" colspan="2">
                    <?php
                    if ($result_cust['cust_active'] == 1) {
                        echo '<a href="acc_share_buy.php?cust=' . $_SESSION['cust_id'] . '">Fines</a>';
                    } else {
                        echo 'Share Account';
                    }
                    ?>
                </th>
            </tr>
            <tr>
                <th>Type</th>
                <th>Amount</th>
            </tr>
            <tr>
                <td>Paid</td>
                <td><?php echo number_format($cust_income_amount) . ' ' . $_SESSION['set_cur']; ?></td>
            </tr>
        </table>
    </div>

    <!-- Inbound Messages Table -->
    <div class="content_left" style="width:60%; margin-top:20px;">
        <p class="heading" style="margin-bottom:.3em;">Inbound Messages (Last 5)</p>
        <table id="tb_table">
            <colgroup>
                <col width="15%">
                <col width="45%">
                <col width="15%">
                <col width="15%">
                <col width="10%">
            </colgroup>
            <tr>
                <th>Sender</th>
                <th>Message</th>
                <th>Timestamp</th>
                <th>Delivery Time</th>
                <th>Status</th>
            </tr>
            <?php
            while ($row_message = mysqli_fetch_assoc($query_inbound_messages)) {
                echo '<tr>
                        <td>' . htmlspecialchars($row_message['phone_number']) . '</td>
                        <td>' . htmlspecialchars($row_message['message']) . '</td>
                        <td>' . date("d.m.Y H:i", strtotime($row_message['timestamp'])) . '</td>
                        <td>' . (!empty($row_message['delivered_time']) ? date("d.m.Y H:i", strtotime($row_message['delivered_time'])) : 'N/A') . '</td>
                        <td>' . htmlspecialchars($row_message['status']) . '</td>
                      </tr>';
            }

            // If no inbound messages are found
            if (mysqli_num_rows($query_inbound_messages) == 0) {
                echo '<tr>
                        <td colspan="5" style="text-align:center;">No inbound messages found.</td>
                      </tr>';
            }
            ?>
        </table>
    </div>

    <!-- Outbound Messages Table -->
    <div class="content_left" style="width:60%; margin-top:20px;">
        <p class="heading" style="margin-bottom:.3em;">Outbound Messages (Last 5)</p>
        <table id="tb_table">
            <colgroup>
                <col width="15%">
                <col width="45%">
                <col width="15%">
                <col width="15%">
                <col width="10%">
            </colgroup>
            <tr>
                <th>Recipient</th>
                <th>Message</th>
                <th>Timestamp</th>
                <th>Delivery Time</th>
                <th>Status</th>
            </tr>
            <?php
            while ($row_outbound_message = mysqli_fetch_assoc($query_outbound_messages)) {
                echo '<tr>
                        <td>' . htmlspecialchars($row_outbound_message['phone_number']) . '</td>
                        <td>' . htmlspecialchars($row_outbound_message['message']) . '</td>
                        <td>' . date("d.m.Y H:i", strtotime($row_outbound_message['timestamp'])) . '</td>
                        <td>' . (!empty($row_outbound_message['delivered_time']) ? date("d.m.Y H:i", strtotime($row_outbound_message['delivered_time'])) : 'N/A') . '</td>
                        <td>' . htmlspecialchars($row_outbound_message['status']) . '</td>
                      </tr>';
            }

            // If no outbound messages are found
            if (mysqli_num_rows($query_outbound_messages) == 0) {
                echo '<tr>
                        <td colspan="5" style="text-align:center;">No outbound messages found.</td>
                      </tr>';
            }
            ?>
        </table>
    </div>
</body>
<?php
if ($share_amount == 0 && $result_cust['cust_active'] == 1) {
    showMessage('This Customer owns no Shares!');
}
?>
</html>