<?php
// Calculate all key metrics for the dashboard with improved accuracy

// 1. MEMBERSHIP METRICS
// Total active members (fixed query)
$total_members = mysqli_fetch_assoc(mysqli_query($db_link, 
    "SELECT COUNT(*) AS count FROM customer WHERE cust_active = 1"))['count'];

// New members in current period (fixed logic)
$new_members = mysqli_fetch_assoc(mysqli_query($db_link, 
    "SELECT COUNT(*) AS count FROM customer 
     WHERE cust_since BETWEEN $financial_start_date AND $financial_end_date"))['count'];

// 2. SAVINGS METRICS (using more accurate queries from second code)
// Total savings balance
$total_savings = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(sav_amount) AS total FROM savings 
     WHERE sav_date <= $financial_end_date"))['total'] ?? 0;

// Savings deposits in period
$savings_deposits = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(sav_amount) AS total FROM savings 
     WHERE savtype_id = 1 AND sav_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;

// Savings withdrawals in period
$savings_withdrawals = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(sav_amount) AS total FROM savings 
     WHERE savtype_id = 2 AND sav_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;
$savings_withdrawals = $savings_withdrawals * -1; // Make withdrawals negative

// 3. SHARES METRICS (using improved calculations from second code)
// Total shares (quantity)
$total_shares = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(share_amount) AS total FROM shares"))['total'] ?? 0;

// Shares purchased in period
$shares_purchased = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(share_amount) AS total FROM shares 
     WHERE share_amount > 0 AND share_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;

// Shares sold in period
$shares_sold = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(share_amount) AS total FROM shares 
     WHERE share_amount < 0 AND share_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;
$shares_sold = $shares_sold * -1; // Make sold shares positive

// Total shares value (from second code)
$total_shares_value = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(share_value) AS total FROM shares"))['total'] ?? 0;

// Current share value (from your existing function)
$shareValue = getCurrentShareValue($db_link);

// 4. LOAN PORTFOLIO METRICS (using improved calculations from second code)
// Total loan portfolio
$total_loans = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(loan_principal) AS total FROM loans 
     WHERE loanstatus_id IN (2,4,5)"))['total'] ?? 0;

// Active loans count
$active_loans = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT COUNT(*) AS count FROM loans WHERE loanstatus_id = 2"))['count'];

// Loans issued in period
$loans_issued = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(loan_principal) AS total FROM loans 
     WHERE loan_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;

// Social loans (0% interest)
$social_loans = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(loan_principal) AS total FROM loans 
     WHERE loan_interest = 0 AND loanstatus_id IN (2,5)"))['total'] ?? 0;

// Normal loans (with interest)
$normal_loans = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(loan_principal) AS total FROM loans 
     WHERE loan_interest > 0 AND loanstatus_id IN (2,4,5)"))['total'] ?? 0;

// Loan repayments in period (principal + interest)
$loan_repayments = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(ltrans_principal + ltrans_interest) AS total FROM ltrans 
     WHERE ltrans_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;

// Loan interest income
$loan_interest_income = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(ltrans_interest) AS total FROM ltrans 
     JOIN loans ON ltrans.loan_id = loans.loan_id
     WHERE ltrans_date BETWEEN $financial_start_date AND $financial_end_date
     AND loans.loanstatus_id IN (2,4,5)"))['total'] ?? 0;

// 5. INCOME METRICS (from second code)
// Total income in period
$total_income = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(inc_amount) AS total FROM incomes 
     WHERE inc_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;

// Loan interest income (alternative calculation)
$loan_interest_income = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(inc_amount) AS total FROM incomes 
     WHERE inctype_id = 4 AND inc_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;

// Other income (non-interest)
$other_income = $total_income - $loan_interest_income;

// 6. EXPENSE METRICS (from second code)
// Total expenses in period
$total_expenses = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(exp_amount) AS total FROM expenses 
     WHERE exp_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;

// Dividend expenses
$dividend_expenses = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(exp_amount) AS total FROM expenses 
     WHERE exptype_id = 18 AND exp_date BETWEEN $financial_start_date AND $financial_end_date"))['total'] ?? 0;

// Other expenses (non-dividend)
$other_expenses = $total_expenses - $dividend_expenses;

// 7. PROFIT CALCULATIONS
$net_profit = $total_income - $total_expenses;

// 8. DIVIDEND CALCULATIONS (using improved logic from second code)
$eligible_dividends = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(s.share_amount * $shareValue) AS total
     FROM shares s
     WHERE s.cust_id IN (
         SELECT l.cust_id FROM loans l
         WHERE l.loan_date BETWEEN $financial_start_date AND $financial_end_date
         GROUP BY l.cust_id HAVING SUM(l.loan_repaytotal) > 2400000
         UNION
         SELECT i.cust_id FROM incomes i
         WHERE i.inc_date BETWEEN $financial_start_date AND $financial_end_date
         AND i.inctype_id = 4
         GROUP BY i.cust_id HAVING SUM(i.inc_amount) > 200000
     )"))['total'] ?? 0;

// 9. PORTFOLIO QUALITY METRICS (from second code)
// Performing loans (on-time payments)
$performing_loans_amount = $normal_loans; // Simplified for this example

// Non-performing loans (delinquent)
$non_performing_loans_amount = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(loan_principal) AS total FROM loans 
     WHERE loanstatus_id = 4"))['total'] ?? 0;

// Portfolio at Risk (PAR)
$par_amount = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(lt.ltrans_principaldue + lt.ltrans_interestdue) AS total
     FROM ltrans lt
     JOIN loans l ON lt.loan_id = l.loan_id
     WHERE l.loanstatus_id = 2
     AND lt.ltrans_date IS NULL
     AND lt.ltrans_due < UNIX_TIMESTAMP()"))['total'] ?? 0;

$par_percentage = $total_loans > 0 ? ($par_amount / $total_loans) * 100 : 0;

// 10. LOAN PERFORMANCE METRICS (from second code)
// Average loan size
$avg_loan_size = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT AVG(loan_principal) AS avg FROM loans 
     WHERE loanstatus_id IN (2,4,5)"))['avg'] ?? 0;

// Median loan size (more accurate calculation)
$median_loan_size = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT loan_principal FROM loans 
     WHERE loanstatus_id IN (2,4,5) 
     ORDER BY loan_principal 
     LIMIT 1 OFFSET (SELECT COUNT(*) FROM loans WHERE loanstatus_id IN (2,4,5)) / 2"))['loan_principal'] ?? 0;

// Average interest rate
$avg_interest_rate = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT AVG(loan_interest) AS avg FROM loans 
     WHERE loanstatus_id IN (2,4,5) AND loan_interest > 0"))['avg'] ?? 0;

// Portfolio Yield
$portfolio_yield = $total_loans > 0 ? ($loan_interest_income / $total_loans) * 100 : 0;

// 11. FINANCIAL RATIOS (from second code)
// Return on Assets
$roa = ($total_savings + $total_shares_value + $total_loans) > 0 ? 
       ($net_profit / ($total_savings + $total_shares_value + $total_loans)) * 100 : 0;

// Debt to Equity Ratio
$debt_to_equity = $total_shares_value > 0 ? $total_loans / $total_shares_value : 0;

// Capital Adequacy Ratio
$capital_adequacy = $total_loans > 0 ? ($total_shares_value / $total_loans) * 100 : 0;

// Loan to Deposit Ratio
$loan_to_deposit = $total_savings > 0 ? ($total_loans / $total_savings) * 100 : 0;

// 12. MONTHLY PERFORMANCE METRICS (from second code)
// Monthly savings collected
$monthly_savings = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(sav_amount) AS total FROM savings 
     WHERE savtype_id = 1 AND sav_date BETWEEN $firstDay AND $lastDay"))['total'] ?? 0;

// Monthly loan repayments
$monthly_loan_repayments = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(ltrans_principal + ltrans_interest) AS total FROM ltrans 
     WHERE ltrans_date BETWEEN $firstDay AND $lastDay"))['total'] ?? 0;

// Monthly loan disbursements
$monthly_loan_disbursements = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(loan_principal) AS total FROM loans 
     WHERE loan_date BETWEEN $firstDay AND $lastDay"))['total'] ?? 0;

// Monthly share purchases
$monthly_share_purchases = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(share_amount) AS total FROM shares 
     WHERE share_amount > 0 AND share_date BETWEEN $firstDay AND $lastDay"))['total'] ?? 0;

// Monthly share sales
$monthly_share_sales = mysqli_fetch_assoc(mysqli_query($db_link,
    "SELECT SUM(share_amount) AS total FROM shares 
     WHERE share_amount < 0 AND share_date BETWEEN $firstDay AND $lastDay"))['total'] ?? 0;
$monthly_share_sales = $monthly_share_sales * -1; // Make positive
?>