<?PHP
/**
	* Establish Database Connection
	*/
	function connect() {
		require_once 'config/config.php';
		$connect = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
		if (!$connect) header('Location:setup.php');
		mysqli_set_charset($connect, 'utf8');
		return $connect;
	}

/**
	* Generate unique fingerprint for every user session
	* @return string fingerprint : Unique fingerprint generated from remote server address,
	* random string, and user agent
	*/
	function fingerprint(){
		return $fingerprint = md5($_SERVER['REMOTE_ADDR'].'jikI/20Y,!'.$_SERVER['HTTP_USER_AGENT']);
	}

/**
	* Check if current user is logged in
	*/
	function checkLogin() {
		$fingerprint = fingerprint();
		session_start();
		if (!isset($_SESSION['log_user']) || $_SESSION['log_fingerprint'] != $fingerprint) logout();
		session_regenerate_id();
	}

/**
	* Check if current user logged out properly last time
	*/
	function checkLogout(){
		if ($_SESSION['logrec_logout'] == 0){
			showMessage("You forgot to logout last time. Please remember to log out properly.");
			$_SESSION['logrec_logout'] = 1;
		}
	}

/**
	* Check if current user has Admin permission
	*/
	function checkPermissionAdmin() {
		if ($_SESSION['log_admin']!=='1'){
			header('Location: start.php');
			die();
		}
	}

/**
	* Check if current user has Delete permission
	*/
	function checkPermissionDelete() {
		if ($_SESSION['log_delete']!=='1'){
			header('Location: start.php');
			die();
		}
	}

/**
	* Check if current user has permission to access Reports
	*/
	function checkPermissionReport() {
		if ($_SESSION['log_report']!=='1'){
			header('Location: start.php');
			die();
		}
	}

	/**
	* Logout procedure: Delete session variables
	* and cookies, destroy user session.
	*/
	function logout(){
	    ob_start();
		/* Delete all Session Variables */
		$_SESSION = array();

		/* If a session cookie was used, delete it */
		if (ini_get("session.use_cookies")) {
			$params = session_get_cookie_params();
			setcookie(session_name(), '', time() - 86400, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
		}

		/* Finally, delete the Session */
		session_destroy();
         
		/* Forward to logout_success.php */
		header('Location: logout_success.php');
		ob_end_flush();
		echo' die';
	//	die;
	}

/**
	* Check if an SQL statement has succeded
	*/
	function checkSQL($db_link, $sqlquery){
		if (!$sqlquery) die ('SQL-Statement failed: '.mysqli_error($db_link));
	}

/**
	* Pushing system settings into session variables
	*/
	function getSettings($db_link){
		$sql_settings = "SELECT * FROM settings";
		$query_settings = mysqli_query($db_link, $sql_settings);
		checkSQL($db_link, $query_settings, $db_link);
		while($row_settings = mysqli_fetch_assoc($query_settings)){

			switch ($row_settings['set_short']){
				case "SET_MSB":
					$_SESSION['set_msb'] = $row_settings['set_value'];
					break;
				case "SET_MLP":
					$_SESSION['set_minlp'] = $row_settings['set_value'];
					break;
				case "SET_XLP":
					$_SESSION['set_maxlp'] = $row_settings['set_value'];
					break;
				case "SET_CUR":
					$_SESSION['set_cur'] = $row_settings['set_value'];
					break;
				case "SET_AUF":
					$_SESSION['set_auf'] = $row_settings['set_value'];
					break;
				case "SET_DEA":
					$_SESSION['set_deact'] = $row_settings['set_value'];
					break;
				case "SET_DBL":
					$_SESSION['set_dashl'] = $row_settings['set_value'];
					break;
				case "SET_DBR":
					$_SESSION['set_dashr'] = $row_settings['set_value'];
					break;
				case "SET_ICL":
					$_SESSION['set_intcalc'] = $row_settings['set_value'];
					break;
				case "SET_GUA":
					$_SESSION['set_maxguar'] = $row_settings['set_value'];
					break;
				case "SET_MEM":
					$_SESSION['set_minmemb'] = $row_settings['set_value'];
					break;
				case "SET_PSR":
					$_SESSION['set_maxpsr'] = $row_settings['set_value'];
					break;
				case "SET_CNO":
					$_SESSION['set_cno'] = $row_settings['set_value'];
					break;
				case "SET_XL1":
					$_SESSION['set_xl1'] = $row_settings['set_value'];
					break;
				case "SET_ENO":
					$_SESSION['set_eno'] = $row_settings['set_value'];
					break;
				case "SET_SFX":
					$_SESSION['set_sfx'] = $row_settings['set_value'];
					break;
				case "SET_CSI":
					$_SESSION['set_csi'] = $row_settings['set_value'];
					break;
				case "SET_F4F":
					$_SESSION['set_f4f'] = $row_settings['set_value'];
					break;
			}
		}
	}

/**
	* Pushing fee settings into session variables
	*/
	function getFees($db_link){
		$sql_fees = "SELECT * FROM fees";
		$query_fees = mysqli_query($db_link, $sql_fees);
		checkSQL($db_link, $query_fees, $db_link);
		while ($row_fees = mysqli_fetch_assoc($query_fees)){
			switch ($row_fees['fee_short']){
				case "FEE_ENT":
					$_SESSION['fee_entry'] = $row_fees['fee_value'];
					break;
				case "FEE_WDL":
					$_SESSION['fee_withdraw'] = $row_fees['fee_value'];
					break;
				case "FEE_STS":
					$_SESSION['fee_stationary'] = $row_fees['fee_value'];
					break;
				case "FEE_ASB":
					$_SESSION['fee_subscr'] = $row_fees['fee_value'];
					break;
				case "FEE_LOF":
					$_SESSION['fee_loan'] = $row_fees['fee_value'];
					break;
				case "FEE_LAP":
					$_SESSION['fee_loanappl'] = $row_fees['fee_value'];
					break;
				case "FEE_LDF":
					$_SESSION['fee_loanfine'] = $row_fees['fee_value'];
					break;
				case "FEE_LIR":
					$_SESSION['fee_loaninterestrate'] = $row_fees['fee_value'];
					break;
				case "FEE_INS":
					$_SESSION['fee_loaninsurance'] = $row_fees['fee_value'];
					break;
				case "FEE_XL1":
					$_SESSION['fee_xl1_name'] = $row_fees['fee_name'];
					$_SESSION['fee_xl1'] = $row_fees['fee_value'];
					break;
			}
		}
	}

/**
	* Pushing current share value into a session variable
	*/
	function getShareValue($db_link){
		$sql_shareval = "SELECT shareval_value FROM shareval WHERE shareval_id IN (SELECT MAX(shareval_id) FROM shareval)";
		$query_shareval = mysqli_query($db_link, $sql_shareval);
		checkSQL($db_link, $query_shareval, $db_link);
		$result_shareval = mysqli_fetch_assoc($query_shareval);
		$_SESSION['share_value'] = $result_shareval['shareval_value'];
	}

/**
	* Sanitize and secure user input
	* @param string var : User Input
	* @return string var : Secured and sanitized User Input
	*/
	function sanitize($db_link, $var) {
		if(get_magic_quotes_gpc()) $var = stripslashes($var);
		$var = htmlentities($var);
		$var = strip_tags($var);
		$var = mysqli_real_escape_string($db_link, $var);
		return $var;
	}

/**
	* Convert a number of days into UNIX timestamp seconds
	* @param int days : Number of days
	* @return int seconds : Lenght of number of days in seconds
	*/
	function convertDays($days){
		return $seconds = $days * 86400;
	}

/**
	* Convert a number of months into UNIX timestamp seconds
	* @param int months : Number of months
	* @return int seconds : Lenght of number of days in seconds
	*/
	function convertMonths($months){
		return $seconds = $months * 2635200; // Seconds for 30.5 days
	}

/**
	* Check if a GET parameter with a Customer ID has been set
	* If not, return to start page.
	*/
	function getCustID($db_link){
		if (isset($_GET['cust'])) $_SESSION['cust_id'] = sanitize($db_link, $_GET['cust']);
		else header('Location: start.php');
	}

/**
	* Check if a GET parameter with a Loan ID has been set
	* If not, return to customer page.
	*/
	function getLoanID($db_link){
		if (isset($_GET['lid'])) $_SESSION['loan_id'] = sanitize($db_link, $_GET['lid']);
		else header('Location: customer.php?cust='.$_SESSION['cust_id']);
	}

/**
	* Generate HTML Header Section
	* @param string title : Page title
	* @param int endFlag : Flag to indicate whether or not to end header section.
	*/
	function includeHead($title, $endFlag = 1) {
		echo '<head>
			<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
			<meta http-equiv="Content-Script-Type" content="text/javascript">
			<meta http-equiv="Content-Style-Type" content="text/css">
			<meta name="robots" content="noindex, nofollow">
			<title>NES | '.$title.'</title>
			<link rel="shortcut icon" href="ico/favicon.ico" type="image/x-icon">
			<link rel="stylesheet" href="css/mangoo.css" />
			<link rel="stylesheet" href="ico/font-awesome/css/font-awesome.min.css">
			<link rel="stylesheet" href="jquery/jquery-ui-1.11.4/jquery-ui.min.css">
			<script src="jquery/jquery-2.2.1.min.js"></script>
			<script src="jquery/jquery-ui-1.11.4/jquery-ui.min.js"></script>
			<script>
				$(function() {
					$("#datepicker, #datepicker2, #datepicker3").datepicker({
						showOtherMonths: true,
						selectOtherMonths: true,
						dateFormat: \'dd.mm.yy\',
						changeMonth: true,
						changeYear: true
					});
				});
			</script>
			';
		if ($endFlag == 1) echo '</head>';
	}

/**
	* Generate Menu bar
	* @param int tab_no : Number of currently selected menu tab.
	*/
	function includeMenu($tab_no){
		echo '
		<!-- MENU HEADER -->
		<div id="menu_header">
		<br>
		<br>
		<!--	<img src="" style="margin: 1em 0 0 .75em;"/>  -->
			<div id="menu_logout">
				<ul>
					<li>'.$_SESSION['log_user'].'
						<ul>
							<li><a href="logout.php"><i class="fa fa-sign-out fa-fw"></i> Logout</a></li>
						</ul>
					</li>
				</ul>
			</div>
		</div>';

		echo '
		<!-- MENU TABS -->
		<div id="menu_tabs">
			<ul>
				<li';
				if ($tab_no == 1) echo ' id="tab_selected"';
				echo '><a href="start.php"><i class="fa fa-tachometer fa-fw"></i> Dashboard</a></li>
				<li';
				if ($tab_no == 2) echo ' id="tab_selected"';
				echo '><a href="cust_act.php"><i class="fa fa-group fa-fw"></i> Customers</a></li>
				<li';
				if ($tab_no == 3) echo ' id="tab_selected"';
				echo '><a href="loans_search.php"><i class="fa fa-percent fa-fw"></i> Loans</a></li>
				<li';

			    if ($_SESSION['log_delete'] =='1'){
				if ($tab_no == 4) echo ' id="tab_selected"';
				echo '><a href="books_expense.php"><i class="fa fa-calculator fa-fw"></i> Accounting</a></li>
				<li';
				if ($tab_no == 7) echo ' id="tab_selected"';
				echo '><a href="empl_curr.php"><i class="fa fa-male fa-fw"></i> Employees</a></li> <li';
				} else {}
				if ($_SESSION['log_report'] == 1){
				//	echo '<li';
					if ($tab_no == 5) echo ' id="tab_selected"';
					echo '><a href="rep_incomes.php"><i class="fa fa-line-chart fa-fw"></i> Reports</a></li> <li';
				}

				if ($_SESSION['log_admin'] == 1){
				//	echo '<li';
					if ($tab_no == 6) echo ' id="tab_selected"';
					echo '><a href="set_basic.php"><i class="fa fa-wrench fa-fw"></i> Settings</a></li>';
				}



			echo '</ul>
		</div>';
	}

/**
	* Generate a Javascript alert message
	* @param string text : Message text
	*/
	function showMessage($text) {
		echo '<script language=javascript>
						alert(\''.$text.'\')
					</script>';
	}

/**
	* Calculate a given customer's savings account balance
	* @return int savbal : Current savings account balance for given customer
	*/
	function getSavingsBalance($db_link, $cust_id){
		$sql_savbal = "SELECT savbal_balance FROM savbalance WHERE cust_id = $cust_id";
		$query_savbal = mysqli_query($db_link, $sql_savbal);
		checkSQL($db_link, $query_savbal);

		$savbal = mysqli_fetch_assoc($query_savbal);

		return $savbal['savbal_balance'];
	}

	/**
		* Calculate a given customer's fixed savings
		* @return int savfixed : Balance of currently fixed savings for given customer
		*/
		function getSavingsFixed($db_link, $cust_id){
			$sql_savfixed = "SELECT savbal_fixed FROM savbalance WHERE cust_id = $cust_id";
			$query_savfixed = mysqli_query($db_link, $sql_savfixed);
			checkSQL($db_link, $query_savfixed);

			$savfixed = mysqli_fetch_assoc($query_savfixed);

			return $savfixed['savbal_fixed'];
		}

/**
	* Update savings account balance for SPECIFIC customer
	*/
	function updateSavingsBalance($db_link, $cust_id){
		$timestamp = time();
		$sql_savbal_upd = "UPDATE savbalance SET savbal_balance = (SELECT SUM(sav_amount) FROM savings WHERE cust_id = $cust_id), savbal_fixed =0 WHERE cust_id = $cust_id";
		$query_savbal_upd = mysqli_query($db_link, $sql_savbal_upd);
		checkSQL($db_link, $query_savbal_upd, $db_link);
	}

/**
	* Update savings account balance for ALL customers
	*/
	function updateSavingsBalanceAll($db_link){
		$sql_savbal_upd_all = "UPDATE savbalance SET savbalance.savbal_balance = (SELECT SUM(savings.sav_amount) FROM savings WHERE savings.cust_id = savbalance.cust_id)";
		$query_savbal_upd_all = mysqli_query($db_link, $sql_savbal_upd_all);
		checkSQL($db_link, $query_savbal_upd_all, $db_link);
	}

/**
	* Calculate balances for a specific loan
	* @return array $loanbal : Array with principal balance,
	*/
	function getLoanBalance($db_link, $loan_id){
		//Select Loan Balance from LTRANS
		$sql_balances = "SELECT ltrans_principaldue, ltrans_interestdue, ltrans_principal, ltrans_interest FROM ltrans WHERE ltrans.loan_id = '$loan_id'";
		$query_balances = mysqli_query($db_link, $sql_balances);
		checkSQL($db_link, $query_balances, $db_link);

		//Calculate outstanding balances
		$loan_balances = array(
			"pdue" => 0,
			"idue" => 0,
			"ppaid" => 0,
			"ipaid" => 0,
			"balance" => 0
		);
		while ($row_balances = mysqli_fetch_assoc($query_balances)){
			$loan_balances['pdue'] = $loan_balances['pdue'] + $row_balances['ltrans_principaldue'];
			$loan_balances['idue'] = $loan_balances['idue'] + $row_balances['ltrans_interestdue'];
			$loan_balances['ppaid'] = $loan_balances['ppaid'] + $row_balances['ltrans_principal'];
			$loan_balances['ipaid'] = $loan_balances['ipaid'] + $row_balances['ltrans_interest'];
		}
		$loan_balances['balance'] = ($loan_balances['pdue'] + $loan_balances['idue']) - ($loan_balances['ppaid'] + $loan_balances['ipaid']);

		return $loan_balances;
	}

/**
	* Calculate current customer's share account balance
	* @return int share_balace : Current share account balance
	*/
	function getShareBalance($db_link, $cust_id){
		$sql_sharebal = "SELECT share_amount, share_value FROM shares WHERE cust_id = $cust_id";
		$query_sharebal = mysqli_query($db_link, $sql_sharebal);
		checkSQL($db_link, $query_sharebal, $db_link);
		$sharebal = array("amount" => "0", "value" => "0");
		while($row_sharebal = mysqli_fetch_assoc($query_sharebal)){
			$sharebal['amount'] = $sharebal['amount'] + $row_sharebal['share_amount'];
			$sharebal['value'] = $sharebal['value'] + $row_sharebal['share_value'];
		}
		return $sharebal;
	}


/**
	* Get current customer's details
	* @return array result_cust : Associative array with the details of the current customer
	*/
	function getCustomer($db_link, $custID){
		$sql_cust = "SELECT * FROM customer LEFT JOIN custsex ON customer.custsex_id = custsex.custsex_id LEFT JOIN custmarried ON customer.custmarried_id = custmarried.custmarried_id LEFT JOIN custsick ON customer.custsick_id = custsick.custsick_id LEFT JOIN user ON customer.user_id = user.user_id WHERE cust_id = '$custID'";
		$query_cust = mysqli_query($db_link, $sql_cust);
		checkSQL($db_link, $query_cust, $db_link);
		$result_cust = mysqli_fetch_assoc($query_cust);

		return $result_cust;
	}
/////////

// ...existing code...

//function saveLoan($applicant_id, $amount) { /* insert into loans, return id */ }
//function getAllMembers() { /* select * from members */ }
function saveApprovalRequest($loan_id, $member_id, $code) {
    global $db_link; // or pass $db_link as a parameter if not global

    $stmt = $db_link->prepare("INSERT INTO loan_approvals (loan_id, member_id, code, status) VALUES (?, ?, ?, 'pending')");
    if (!$stmt) {
        error_log("Prepare failed: " . $db_link->error);
        return false;
    }
    $stmt->bind_param("iis", $loan_id, $member_id, $code);
    $result = $stmt->execute();
    if (!$result) {
        error_log("Execute failed: " . $stmt->error);
    }
    $stmt->close();
    return $result;
}
//function sendSMS($phone, $message) { /* integrate with SMS gateway */ }
function getLoanApprovalByCode($code) {
    global $db_link; // or pass $db_link as a parameter if not global

    $stmt = $db_link->prepare("SELECT * FROM loan_approvals WHERE code = ?");
    if (!$stmt) {
        error_log("Prepare failed: " . $db_link->error);
        return false;
    }
    $stmt->bind_param("s", $code);
    $stmt->execute();
    $result = $stmt->get_result();
    $approval = $result->fetch_assoc();
    $stmt->close();
    return $approval; // returns associative array or null if not found
}
function updateLoanApprovalStatus($approval_id, $status) {
    global $db_link; // or pass $db_link as a parameter if not global

    $stmt = $db_link->prepare("UPDATE loan_approvals SET status = ?, responded_at = NOW() WHERE id = ?");
    if (!$stmt) {
        error_log("Prepare failed: " . $db_link->error);
        return false;
    }
    $stmt->bind_param("si", $status, $approval_id);
    $result = $stmt->execute();
    if (!$result) {
        error_log("Execute failed: " . $stmt->error);
    }
    $stmt->close();
    return $result;
}

function allLoanApprovalsAreApproved($loan_id) {
    global $db_link; // or pass $db_link as a parameter if not global

    $stmt = $db_link->prepare("SELECT COUNT(*) AS cnt FROM loan_approvals WHERE loan_id = ? AND status != 'approved'");
    if (!$stmt) {
        error_log("Prepare failed: " . $db_link->error);
        return false;
    }
    $stmt->bind_param("i", $loan_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();

    return ($row['cnt'] == 0);
}



// ...existing code...





/**
	* Get all customers except current one
	* @return array query_custother : Array with the result of the SQL query
	*/
	function getCustOther($db_link){
		$sql_custother = "SELECT * FROM customer LEFT JOIN custsex ON custsex.custsex_id = customer.custsex_id WHERE cust_id NOT IN (0, $_SESSION[cust_id]) ORDER BY cust_id";
		$query_custother = mysqli_query($db_link, $sql_custother);
		checkSQL($db_link, $query_custother, $db_link);

		return $query_custother;
	}

/**
	* Get all active customers
	* @return array query_custact : Array with the result of the SQL query
	*/
	function getCustAct($db_link){
		$sql_custact = "SELECT * FROM customer LEFT JOIN custsex ON custsex.custsex_id = customer.custsex_id WHERE cust_id != 0 AND cust_active = 1 ORDER BY cust_id";
		$query_custact = mysqli_query($db_link, $sql_custact);
		checkSQL($db_link, $query_custact, $db_link);

		return $query_custact;
	}

/**
	* Get all inactive customers
	* @return array query_custinact : Array with the result of the SQL query
	*/
	function getCustInact($db_link){
		$sql_custinact = "SELECT * FROM customer LEFT JOIN custsex ON custsex.custsex_id = customer.custsex_id WHERE cust_id != 0 AND cust_active != 1 ORDER BY cust_id";
		$query_custinact = mysqli_query($db_link, $sql_custinact);
		checkSQL($db_link, $query_custinact, $db_link);

		return $query_custinact;
	}

/**
	* Get all customers
	* @return array query_custall : Array with the result of the SQL query
	*/
	function getCustAll($db_link){
		$sql_custall = "SELECT * FROM customer LEFT JOIN custsex ON custsex.custsex_id = customer.custsex_id WHERE cust_id !=0";
		$query_custall = mysqli_query($db_link, $sql_custall);
		checkSQL($db_link, $query_custall, $db_link);

		return $query_custall;
	}

/**
	* Get customers with overdue subscription fee
	* @return array query_custoverdue : Array with the result of the SQL query
	*/
	function getCustOverdue($db_link){
		$last_subscr = time() - convertDays(365); //Seconds for 365 days
		$sql_custoverdue = "SELECT * FROM customer WHERE cust_active = 1 AND cust_lastsub < $last_subscr ORDER BY cust_lastsub, cust_id";
		$query_custoverdue = mysqli_query($db_link, $sql_custoverdue);
		checkSQL($db_link, $query_custoverdue, $db_link);

		return $query_custoverdue;
	}

/**
	* Build new customer number
	* @return varchar custNo :  Newly build customer number
	*/
	function buildCustNo($db_link){
		// Determine biggest customer ID
		$sql_maxID = "SELECT MAX(cust_id) AS maxid FROM customer";
		$query_maxID = mysqli_query($db_link, $sql_maxID);
		checkSQL($db_link, $query_maxID);
		$result_maxID = mysqli_fetch_array($query_maxID);

		// Read customer number format
		$cnParts = explode("%", $_SESSION['set_cno']);
		$cnCount = count($cnParts);

		// Build customer number
		$i = 0;
		$custNo = "";
		for ($i = 1; $i < $cnCount; $i++) {
			switch($cnParts[$i]){
				case "N":
					$custNo = $custNo.($result_maxID['maxid'] + 1);
					break;
				case "Y":
					$custNo = $custNo.date("Y",time());
					break;
				case "M":
					$custNo = $custNo.date("m",time());
					break;
				case "D":
					$custNo = $custNo.date("d",time());
					break;
				default:
					$custNo = $custNo.$cnParts[$i];
			}
		}

		// Return customer number
		return $custNo;
	}

/**
	* Get current employee
	* @return array result_empl :  Associative array with the details of the current employee
	*/
	function getEmployee($db_link, $empl_id){
		$sql_empl = "SELECT * FROM employee LEFT JOIN user ON employee.empl_id = user.empl_id WHERE employee.empl_id = $empl_id";
		$query_empl = mysqli_query($db_link, $sql_empl);
		checkSQL($db_link, $query_empl, $db_link);
		$result_empl = mysqli_fetch_assoc($query_empl);

		return $result_empl;
	}

/**
	* Get all current employees
	* @return array query_emplcurr : Array with the result of the SQL query
	*/
	function getEmplCurr($db_link){
		$timestamp = time();
		$sql_emplcurr = "SELECT * FROM employee LEFT JOIN emplsex ON employee.emplsex_id = emplsex.emplsex_id LEFT JOIN emplmarried ON employee.emplmarried_id = emplmarried.emplmarried_id WHERE empl_id != 0 AND (empl_out > $timestamp OR empl_out IS NULL) ORDER BY empl_id";
		$query_emplcurr = mysqli_query($db_link, $sql_emplcurr);
		checkSQL($db_link, $query_emplcurr, $db_link);

		return $query_emplcurr;
	}

/**
	* Get all past employees
	* @return array query_emplpast : Array with the result of the SQL query
	*/
	function getEmplPast($db_link){
		$timestamp = time();
		$sql_emplpast = "SELECT * FROM employee LEFT JOIN emplsex ON employee.emplsex_id = emplsex.emplsex_id LEFT JOIN emplmarried ON employee.emplmarried_id = emplmarried.emplmarried_id WHERE empl_id != 0 AND empl_out < $timestamp ORDER BY empl_id";
		$query_emplpast = mysqli_query($db_link, $sql_emplpast);
		checkSQL($db_link, $query_emplpast, $db_link);

		return $query_emplpast;
	}

/**
	* Build new employee number
	* @return varchar emplNo :  Newly build employee number
	*/
	function buildEmplNo($db_link){
		// Determine biggest employee ID
		$sql_maxID = "SELECT MAX(empl_id) AS maxid FROM employee";
		$query_maxID = mysqli_query($db_link, $sql_maxID);
		checkSQL($db_link, $query_maxID, $db_link);
		$result_maxID = mysqli_fetch_array($query_maxID);

		// Read employee number format
		$enParts = explode("%", $_SESSION['set_eno']);
		$enCount = count($enParts);

		// Build customer number
		$i = 0;
		$emplNo = "";
		for ($i = 1; $i < $enCount; $i++) {
			switch($enParts[$i]){
				case "N":
					$emplNo = $emplNo.($result_maxID['maxid'] + 1);
					break;
				case "Y":
					$emplNo = $emplNo.date("Y",time());
					break;
				case "M":
					$emplNo = $emplNo.date("m",time());
					break;
				case "D":
					$emplNo = $emplNo.date("d",time());
					break;
				default:
					$emplNo = $emplNo.$enParts[$i];
			}
		}

		// Return employee number
		return $emplNo;
	}

/**
	* Get all overdue Loan Instalments
	* @return array query_overdue : Array with the result of the SQL query
	*/
	function getLtransOverdue($db_link){
		$timestamp = time();
		$sql_overdue = "SELECT * FROM ltrans LEFT JOIN loans ON ltrans.loan_id = loans.loan_id LEFT JOIN customer ON loans.cust_id = customer.cust_id WHERE ltrans_due <= $timestamp AND ltrans_date IS NULL AND loanstatus_id = 2 ORDER BY ltrans_due";
		$query_overdue = mysqli_query($db_link, $sql_overdue);
		checkSQL($db_link, $query_overdue, $db_link);
		return $query_overdue;
	}

/**
	* Get all securities which belong to a given loan
	* @return array securities : Array with the result of the SQL query
	*/
	function getLoanSecurities($db_link, $loan_id){
		$sql_secur = "SELECT * FROM securities WHERE loan_id = $loan_id";
		$query_secur = mysqli_query($db_link, $sql_secur);
		checkSQL($db_link, $query_secur);
		$securities = array();
		while ($row_secur = mysqli_fetch_assoc($query_secur)) $securities[] = $row_secur;
		return $securities;
	}

/**
	* Get details of a given loan security
	* @return array result_sec : Array with the result of the SQL query
	*/
	function getSecurity($db_link, $sec_id){
		$sql_sec = "SELECT * FROM securities LEFT JOIN loans ON securities.loan_id = loans.loan_id LEFT JOIN customer ON securities.cust_id = customer.cust_id WHERE sec_id = $sec_id";
		$query_sec = mysqli_query($db_link, $sql_sec);
		checkSQL($db_link, $query_sec);
		$result_sec = mysqli_fetch_assoc($query_sec);
		return $result_sec;
	}
//Get Company name
function getCompanyName($db_link) {
    $sql = "SELECT set_value FROM settings WHERE set_id = 19";
    $query = mysqli_query($db_link, $sql);
    checkSQL($db_link, $query);
    $result = mysqli_fetch_assoc($query);
    return $result['set_value'];
}
// Get group share value
function getCurrentShareValue($db_link) {
    $sql = "SELECT shareval_value FROM shareval ORDER BY shareval_date DESC LIMIT 1";
    $query = mysqli_query($db_link, $sql);
    checkSQL($db_link, $query);
    $result = mysqli_fetch_assoc($query);
    return $result ? $result['shareval_value'] : 0; // Default value if no share value is found
}

// Function to process the "amenunua hisa" keyword
function processAmenunuaHisa($db_link, $normalizedFrom, $message) {
    error_log("Keyword 'amenunua hisa' found in message. Processing share purchase...");

    // Fetch the company name from the settings table
    $companyNameQuery = "SELECT `set_value` FROM `settings` WHERE `set_id` = 19";
    $companyNameResult = mysqli_query($db_link, $companyNameQuery);
    if ($companyNameResult && mysqli_num_rows($companyNameResult) > 0) {
        $companyNameRow = mysqli_fetch_assoc($companyNameResult);
        $companyName = $companyNameRow['set_value'];
    } else {
        $companyName = " "; // Fallback in case the query fails
    }

    // Check if the company name is present in the message
    if (strpos(strtoupper($message), strtoupper($companyName)) === false) {
        error_log("Company name '$companyName' not found in the message.");
        return; // Exit the function if the company name is not found
    }

    // Extract the phone number from the message (first 10 characters)
    $phoneNumber = substr($message, 0, 12); // Extract the first 12 characters as the phone number

    if (!$phoneNumber) {
        error_log("Phone number not found in the message.");
        return; // Exit if no phone number is found
    }

    // Extract the amount from the message
    preg_match('/Tsh\.([0-9,]+)\.00/', $message, $matches);
    $amount = isset($matches[1]) ? str_replace(',', '', $matches[1]) : 0;

    if ($amount > 0) {
        // Fetch the customer ID (cust_id) based on the extracted phone number
        $sql_cust = "SELECT cust_id, cust_name FROM customer WHERE cust_phone = '$phoneNumber'";
        $query_cust = mysqli_query($db_link, $sql_cust);

        if ($query_cust && mysqli_num_rows($query_cust) > 0) {
            $row_cust = mysqli_fetch_assoc($query_cust);
            $cust_id = $row_cust['cust_id']; // Fetch cust_id from the database
            $cust_name = $row_cust['cust_name']; // Fetch customer name

            // Fetch the current share value from the shareval table
            $shareValueQuery = "SELECT `shareval_value` FROM `shareval` ORDER BY `shareval_date` DESC LIMIT 1";
            $shareValueResult = mysqli_query($db_link, $shareValueQuery);
            if ($shareValueResult && mysqli_num_rows($shareValueResult) > 0) {
                $shareValueRow = mysqli_fetch_assoc($shareValueResult);
                $shareValue = $shareValueRow['shareval_value'];
            } else {
                $shareValue = 0; // Fallback in case the query fails
            }

            // Calculate the number of shares purchased
            $numberOfShares = $amount / $shareValue;

            // Insert the share purchase into the shares table
            $shareDate = time(); // Current timestamp
            $shareReceipt = "AUTO-" . uniqid(); // Generate a unique receipt number
            $sql_insert_sh = "INSERT INTO shares (cust_id, share_date, share_amount, share_value, share_receipt, share_created, user_id) 
                               VALUES ('$cust_id', '$shareDate', '$numberOfShares', '$amount', '$shareReceipt', $shareDate, 1)"; // Assuming user_id = 1 for now
            $query_insert_sh = mysqli_query($db_link, $sql_insert_sh);

            if ($query_insert_sh) {
                // Calculate the new shares balance
                $sql_shares_balance = "SELECT SUM(share_amount) AS total_shares FROM shares WHERE cust_id = '$cust_id'";
                $query_shares_balance = mysqli_query($db_link, $sql_shares_balance);
                $row_shares_balance = mysqli_fetch_assoc($query_shares_balance);
                $total_shares = $row_shares_balance['total_shares'] * $shareValue;

                // Prepare SMS content
                $smsContent = "Dear $cust_name, your purchase of $numberOfShares shares worth " . number_format($amount, 2) . " TSH has been successfully processed. Your new shares balance is " . number_format($total_shares, 2) . " TSH. $companyName!";

                // Send SMS to the extracted phone number
                sendSMS($phoneNumber, $smsContent, $db_link);
            } else {
                error_log("Failed to insert share purchase into the database: " . mysqli_error($db_link));
            }
        } else {
            error_log("Customer not found for phone number: $phoneNumber");
        }
    } else {
        error_log("Invalid amount extracted from the message.");
    }
}

// Function to send SMS
function sendSMS($phoneNumber, $message, $db_link) {
    // SMS Gateway credentials
    $username = "LMXGCL"; // Replace with your SMS gateway username
    $password = "v7uvnnhfhaqzpy"; // Replace with your SMS gateway password
    $credentials = base64_encode("$username:$password");

    // SMS data for the new gateway
    $smsData = [
        'isEncrypted' => false,
        'message' => $message,
        'phoneNumbers' => ["+$phoneNumber"], // Ensure the phone number starts with +
        'simNumber' => 2,
        'withDeliveryReport' => true
    ];

    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.sms-gate.app/3rdparty/v1/messages?skipPhoneValidation=false");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($smsData)); // Send JSON data
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true); // Enable SSL verification
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2); // Verify the host

    // Set headers
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'accept: application/json',
        'authorization: Basic ' . $credentials,
        'Content-Type: application/json'
    ]);

    // Execute the request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Decode the JSON response
    $responseData = json_decode($response, true);

    // Check for errors
    if (curl_errno($ch)) {
        error_log("Error sending SMS to $phoneNumber: " . curl_error($ch));
    } else {
        error_log("SMS sent to $phoneNumber: HTTP Status Code: $httpCode, Response: $response");

        // Insert SMS details into the sms_messages table if the SMS was accepted
        if ($httpCode == 202) {
            $gateway_id = $responseData['id']; // Get the gateway ID from the response
            $sms_status = 'pending'; // Set status to pending
            $sms_direction = 'out'; // Since this is an outgoing SMS

            // Convert Unix timestamp to EAT (UTC+3)
            $eat_timestamp = date('Y-m-d H:i:s', time() + (3 * 3600)); // Add 3 hours for EAT

            // Insert into sms_messages table
            $sql_insert_sms = "INSERT INTO sms_messages (id, type, phone_number, message, timestamp, status, direction) 
                               VALUES ('$gateway_id', 'outbound', '+$phoneNumber', '$message', '$eat_timestamp', '$sms_status', '$sms_direction')";

            $query_insert_sms = mysqli_query($db_link, $sql_insert_sms);

            if (!$query_insert_sms) {
                error_log("Failed to insert SMS into sms_messages table: " . mysqli_error($db_link));
            } else {
                error_log("SMS details inserted into sms_messages table with gateway_id: $gateway_id");
            }
        }
    }

    // Close cURL
    curl_close($ch);
}

// Function to process the "REPORT" keyword
function processReport($db_link, $normalizedFrom, $message) {
    error_log("Keyword 'REPORT' found in message. Processing financial report...");

    // Fetch financial start and end months from the date_settings table
    $financialMonthsQuery = "SELECT variable_name, variable_value FROM date_settings WHERE variable_name IN ('financial_start_month', 'financial_end_month')";
    $financialMonthsResult = mysqli_query($db_link, $financialMonthsQuery);

    if (!$financialMonthsResult) {
        error_log("Failed to fetch financial months: " . mysqli_error($db_link));
        die("Failed to fetch financial months: " . mysqli_error($db_link));
    }

    $financialMonths = [];
    while ($row = mysqli_fetch_assoc($financialMonthsResult)) {
        $financialMonths[$row['variable_name']] = (int)$row['variable_value'];
    }

    // Get the current year and month
    $currentYear = (int)date('Y');
    $currentMonth = (int)date('n');

    // Calculate the financial year start and end dates
    $financialStartMonth = $financialMonths['financial_start_month'];
    $financialEndMonth = $financialMonths['financial_end_month'];

    if ($currentMonth >= $financialStartMonth) {
        // Financial year started in the current year
        $financialStartYear = $currentYear;
        $financialEndYear = $currentYear + 1;
    } else {
        // Financial year started in the previous year
        $financialStartYear = $currentYear - 1;
        $financialEndYear = $currentYear;
    }

    // Calculate financial start and end dates
    $financial_start_date = mktime(0, 0, 0, $financialStartMonth, 1, $financialStartYear);
    $financial_end_date = mktime(23, 59, 59, $financialEndMonth, 31, $financialEndYear);

    // Calculate the first and last day of the current month
    $firstDay = mktime(0, 0, 0, $currentMonth, 1, $currentYear); // First day of the current month
    $lastDay = mktime(23, 59, 59, $currentMonth, date('t', $firstDay), $currentYear); // Last day of the current month

    // Fetch the company name from the settings table
    $companyNameQuery = "SELECT `set_value` FROM `settings` WHERE `set_id` = 19";
    $companyNameResult = mysqli_query($db_link, $companyNameQuery);
    if ($companyNameResult && mysqli_num_rows($companyNameResult) > 0) {
        $companyNameRow = mysqli_fetch_assoc($companyNameResult);
        $companyName = $companyNameRow['set_value'];
    } else {
        $companyName = " "; // Fallback in case the query fails
    }

    // Fetch the latest share value from the shareval table
    $shareValueQuery = "SELECT `shareval_value` FROM `shareval` ORDER BY `shareval_date` DESC LIMIT 1";
    $shareValueResult = mysqli_query($db_link, $shareValueQuery);
    if ($shareValueResult && mysqli_num_rows($shareValueResult) > 0) {
        $shareValueRow = mysqli_fetch_assoc($shareValueResult);
        $shareValue = $shareValueRow['shareval_value'];
    } else {
        $shareValue = 0; // Fallback in case the query fails
    }

    // Fetch data for the specific customer
    $sql = "-- Step 1: Calculate the total income for the financial period 
    WITH TotalIncome AS (
        SELECT 
            IFNULL(SUM(i.inc_amount), 0) AS total_income
        FROM incomes i
        WHERE i.inc_date BETWEEN $financial_start_date AND $financial_end_date
    ),

    -- Step 2: Calculate the total shares of eligible customers
    EligibleShares AS (
        SELECT 
            IFNULL(SUM(s.share_amount), 0) AS total_shares
        FROM shares s
        JOIN customer c ON s.cust_id = c.cust_id
        WHERE 
            (SELECT IFNULL(SUM(l.loan_repaytotal), 0) FROM loans l WHERE l.cust_id = c.cust_id AND l.loan_date BETWEEN $financial_start_date AND $financial_end_date) > 2400000
            OR 
            (SELECT IFNULL(SUM(i2.inc_amount), 0) FROM incomes i2 WHERE i2.cust_id = c.cust_id AND i2.inc_date BETWEEN $financial_start_date AND $financial_end_date AND i2.inctype_id = 4) > 200000
    ),

    -- Step 3: Calculate the share value
    ShareValue AS (
        SELECT 
            (SELECT total_income FROM TotalIncome) / 
            (SELECT total_shares FROM EligibleShares) AS share_value
    ),

    -- Step 4: Calculate PVE for each loan (WITH DATE FILTER)
    LoanPVE AS (
        SELECT 
            l.cust_id,
            l.loan_id,
            IFNULL(SUM(lt.ltrans_principal + lt.ltrans_interest), 0) AS loan_paid,
            (l.loan_repaytotal / l.loan_period) AS loan_expected,
            IFNULL(
                (SUM(lt.ltrans_principal + lt.ltrans_interest) / NULLIF((l.loan_repaytotal / l.loan_period), 0)) * 100, 0
            ) AS loan_pve
        FROM loans l
        LEFT JOIN ltrans lt ON l.loan_id = lt.loan_id
        WHERE l.loanstatus_id = 2 -- Active loans
          AND lt.ltrans_date BETWEEN $firstDay AND $lastDay -- Critical fix: Filter payments to the current month
        GROUP BY l.loan_id, l.cust_id, l.loan_repaytotal, l.loan_period
    ),

    -- Step 5: Calculate remaining installments and monthly installment for each loan (ignoring current month's payments)
    LoanRemaining AS (
        SELECT 
            l.cust_id,
            l.loan_id,
            l.loan_repaytotal,
            l.loan_period,
            FROM_UNIXTIME(l.loan_date) AS loan_date, -- Convert Unix timestamp to MySQL date
            DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH) AS loan_enddate, -- Dynamically calculate loan_enddate
            GREATEST(
                (YEAR(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - YEAR(CURDATE())) * 12 + 
                (MONTH(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - MONTH(CURDATE())) + 1, 
                1
            ) AS remaining_installments, -- Ensure at least 1 installment
            (l.loan_repaytotal - IFNULL(SUM(CASE WHEN lt.ltrans_date NOT BETWEEN $firstDay AND $lastDay THEN lt.ltrans_principal + lt.ltrans_interest ELSE 0 END), 0)) AS remaining_balance, -- Exclude current month's payments
            (l.loan_repaytotal - IFNULL(SUM(CASE WHEN lt.ltrans_date NOT BETWEEN $firstDay AND $lastDay THEN lt.ltrans_principal + lt.ltrans_interest ELSE 0 END), 0)) / 
            GREATEST(
                (YEAR(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - YEAR(CURDATE())) * 12 + 
                (MONTH(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - MONTH(CURDATE())) + 1, 
                1
            ) AS monthly_installment -- Ensure at least 1 installment
        FROM loans l
        LEFT JOIN ltrans lt ON l.loan_id = lt.loan_id
        WHERE l.loanstatus_id = 2 -- Active loans
        GROUP BY l.loan_id, l.cust_id, l.loan_repaytotal, l.loan_period, l.loan_date
    )

    -- Step 6: Main query to fetch customer data and calculate dividends
    SELECT 
        c.cust_id,
        c.cust_name,
        c.cust_group,
        c.cust_phone,
        (SELECT IFNULL(SUM(s.share_amount), 0) FROM shares s WHERE s.cust_id = c.cust_id) AS total_share,
        (SELECT IFNULL(SUM(s.share_amount), 0) FROM shares s WHERE s.cust_id = c.cust_id) * $shareValue AS total_share_value,

        -- Shares Current Month (multiplied by share value)
        (SELECT IFNULL(SUM(s.share_amount), 0) FROM shares s WHERE s.cust_id = c.cust_id AND s.share_date BETWEEN $firstDay AND $lastDay) * $shareValue AS shares_current_month,

        -- Jamii Current Month (savings deposited in the current month)
        (SELECT IFNULL(SUM(sv.sav_amount), 0) FROM savings sv WHERE sv.cust_id = c.cust_id AND sv.sav_date BETWEEN $firstDay AND $lastDay) AS jamii_current_month,

        -- Jamii Loans (0% interest)
        (SELECT IFNULL(SUM(l.loan_repaytotal / l.loan_period), 0) FROM loans l WHERE l.cust_id = c.cust_id AND l.loanstatus_id = 2 AND l.loan_interest = 0) AS jamii_expected_monthly_instalment,

        -- Normal Loans (with interest)
        (SELECT IFNULL(SUM(lr.monthly_installment), 0) FROM LoanRemaining lr WHERE lr.cust_id = c.cust_id) AS monthly_installment,
        (SELECT IFNULL(SUM(lt.ltrans_principal + lt.ltrans_interest), 0) FROM ltrans lt WHERE lt.loan_id IN (SELECT l.loan_id FROM loans l WHERE l.cust_id = c.cust_id AND l.loanstatus_id = 2 AND l.loan_interest > 0) AND lt.ltrans_date BETWEEN $firstDay AND $lastDay) AS normal_paid_monthly_instalment,

        -- Remaining Loan Balance (using LoanRemaining CTE)
        (SELECT IFNULL(SUM(lr.remaining_balance), 0) FROM LoanRemaining lr WHERE lr.cust_id = c.cust_id) AS remaining_loan_balance,

        -- PVE Percentage (Portfolio at Risk) - Loan-specific aggregation
        IFNULL(
            (SELECT AVG(loan_pve) FROM LoanPVE lp WHERE lp.cust_id = c.cust_id), 0
        ) AS pve_percentage,

        -- Share Value (from the CTE)
        (SELECT share_value FROM ShareValue) AS share_value,

        -- Dividends (shares * share value) ONLY FOR ELIGIBLE CUSTOMERS
        CASE
            WHEN 
                (SELECT IFNULL(SUM(l.loan_repaytotal), 0) FROM loans l WHERE l.cust_id = c.cust_id AND l.loan_date BETWEEN $financial_start_date AND $financial_end_date) > 2400000
                OR 
                (SELECT IFNULL(SUM(i2.inc_amount), 0) FROM incomes i2 WHERE i2.cust_id = c.cust_id AND i2.inc_date BETWEEN $financial_start_date AND $financial_end_date AND i2.inctype_id = 4) > 200000
            THEN 
                (SELECT IFNULL(SUM(s.share_amount), 0) FROM shares s WHERE s.cust_id = c.cust_id) * (SELECT share_value FROM ShareValue)
            ELSE 
                0
        END AS dividends
    FROM 
        customer c
    LEFT JOIN 
        LoanPVE lp ON c.cust_id = lp.cust_id
    LEFT JOIN 
        LoanRemaining lr ON c.cust_id = lr.cust_id
    WHERE 
        c.cust_phone = '$normalizedFrom' -- Fetch data for the specific customer
    GROUP BY 
        c.cust_id
    ORDER BY 
        c.cust_group, c.cust_name;";

    $query = mysqli_query($db_link, $sql);
    checkSQL($db_link, $query);

    if (mysqli_num_rows($query) > 0) {
        $row = mysqli_fetch_assoc($query);

        // Prepare the SMS content
    $customerName = $row['cust_name'];
    $customerPhone = $row['cust_phone'];
    $totalShare = number_format($row['total_share'], 2);
    $totalShareValue = number_format($row['total_share_value'], 2);
    $sharesCurrentMonth = number_format($row['shares_current_month'], 2);
    $jamiiCurrentMonth = number_format($row['jamii_current_month'], 2);
    $jamiiExpectedMonthlyInstalment = number_format($row['jamii_expected_monthly_instalment'], 2);
    $monthlyInstallment = number_format($row['monthly_installment']-$row['jamii_expected_monthly_instalment'], 2);
    $normalPaidMonthlyInstalment = number_format($row['normal_paid_monthly_instalment'], 2);
    $remainingLoanBalance = number_format($row['remaining_loan_balance']-$row['normal_paid_monthly_instalment'], 2);
    $pvePercentage = number_format($row['pve_percentage'], 2);
    $dividends = number_format($row['dividends'], 2);

        $smsContent = "Hello $customerName,\n";
        $smsContent .= "Your monthly current report details as at " . date('F Y', $firstDay) . ":\n";
        $smsContent .= "Total Share: $totalShare \n";
        $smsContent .= "Total Share Value: $totalShareValue TSH\n";
        $smsContent .= "Shares Current Month: $sharesCurrentMonth TSH\n";
        $smsContent .= "Jamii Current Month: $jamiiCurrentMonth TSH\n";
        $smsContent .= "Jamii Expected Monthly Instalment: $jamiiExpectedMonthlyInstalment TSH\n";
        $smsContent .= "Loan Monthly Instalment: $monthlyInstallment TSH\n";
        $smsContent .= "Loan Paid Monthly Instalment: $normalPaidMonthlyInstalment TSH\n";
        $smsContent .= "Remaining Loan Balance: $remainingLoanBalance TSH\n";
        $smsContent .= "Dividends: $dividends TSH \n";
        $smsContent .= "Thank you for being a valued member of $companyName.";

        // Send SMS
        sendSMS($normalizedFrom, $smsContent, $db_link);
    } else {
        error_log("Customer not found for phone number: $normalizedFrom");
    }
}

//amelipaJamii
function AmelipaJamii($db_link, $normalizedFrom, $message) {
    error_log("[" . time() . "] Processing Jamii payment...");

    // 1. Validate required keywords and company name
    $messageUpper = strtoupper($message);
    if (strpos($messageUpper, "AMELIPA") === false || 
        strpos($messageUpper, "MFUKO WA JAMII") === false) {
        error_log("Missing required keywords");
        return;
    }

    // Get company name for validation
    $companyResult = mysqli_query($db_link, "SELECT set_value FROM settings WHERE set_id = 19 LIMIT 1");
    $companyName = $companyResult ? mysqli_fetch_assoc($companyResult)['set_value'] : '';
    
    if (empty($companyName) || strpos($messageUpper, strtoupper($companyName)) === false) {
        error_log("Company name '$companyName' not found in message");
        return;
    }

    // 2. Extract phone number (first 12 digits)
    $phoneNumber = substr($message, 0, 12);
    if (!preg_match('/^255\d{9}$/', $phoneNumber)) {
        error_log("Invalid phone number format: $phoneNumber");
        return;
    }

    // 3. Extract payment amount
    if (!preg_match('/Tsh\.([0-9,]+)\.00/', $message, $matches)) {
        error_log("Amount format invalid in message: " . substr($message, 0, 50));
        return;
    }
    $amount = (int)str_replace(',', '', $matches[1]);

    // 4. Get customer details
    $customer = mysqli_fetch_assoc(mysqli_query($db_link, 
        "SELECT cust_id, cust_name FROM customer WHERE cust_phone = '$phoneNumber' LIMIT 1"
    ));
    if (!$customer) {
        error_log("Customer not found for phone: $phoneNumber");
        return;
    }

    // 5. Check for active 0% interest loans
    $loan = mysqli_fetch_assoc(mysqli_query($db_link,
        "SELECT loan_id,loan_no, loan_principalapproved FROM loans 
         WHERE cust_id = '{$customer['cust_id']}' 
         AND loan_interest = 0 
         AND loanstatus_id = 2 
         LIMIT 1"
    ));

    $timestamp = time();
    $receipt = "JAMII-" . date('Ymd-His', $timestamp) . "-" . substr(uniqid(), -6);

    // 6. Process payment
    if ($loan) {
        // Calculate remaining loan balance
        $paid = mysqli_fetch_assoc(mysqli_query($db_link,
            "SELECT COALESCE(SUM(ltrans_principal), 0) AS total_paid 
             FROM ltrans 
             WHERE loan_id = '{$loan['loan_id']}'"
        ));
        $remaining = $loan['loan_principalapproved'] - $paid['total_paid'];

        if ($remaining > 0) {
            // Case 1: Pay towards active loan
            $repayAmount = min($amount, $remaining);
            
            // Record loan repayment
            mysqli_query($db_link,
                "INSERT INTO ltrans (
                    loan_id, ltrans_date, ltrans_principal, 
                    ltrans_interest, ltrans_receipt, ltrans_created, user_id
                 ) VALUES (
                    '{$loan['loan_id']}', $timestamp, $repayAmount,
                    0, '$receipt', $timestamp, 1
                 )"
            );

            // Handle excess
            $excess = $amount - $repayAmount;
            if ($excess > 0) {
                mysqli_query($db_link,
                    "INSERT INTO savings (
                        cust_id, sav_date, sav_amount, 
                        savtype_id, sav_receipt, sav_created, user_id
                     ) VALUES (
                        '{$customer['cust_id']}', $timestamp, $excess,
                        1, '$receipt', $timestamp, 1
                     )"
                );
            }

            // Get updated savings balance
            $savings = mysqli_fetch_assoc(mysqli_query($db_link,
                "SELECT COALESCE(SUM(sav_amount), 0) AS balance 
                 FROM savings 
                 WHERE cust_id = '{$customer['cust_id']}'"
            ));

            // Prepare SMS
            $sms = "Dear {$customer['cust_name']}, " .
                   number_format($repayAmount) . " TSH paid to Loan #: {$loan['loan_no']}. ";
            if ($excess > 0) {
                $sms .= number_format($excess) . " TSH added to Jamii. ";
            }
            $sms .= "Remaining loan: " . number_format($remaining - $repayAmount) . " TSH. " .
                   "New Jamii balance: " . number_format($savings['balance']) . " TSH. $companyName";
        } else {
            // Case 2: Loan exists but is fully paid
            mysqli_query($db_link,
                "INSERT INTO savings (
                    cust_id, sav_date, sav_amount, 
                    savtype_id, sav_receipt, sav_created, user_id
                 ) VALUES (
                    '{$customer['cust_id']}', $timestamp, $amount,
                    1, '$receipt', $timestamp, 1
                 )"
            );

            // Get updated savings balance
            $savings = mysqli_fetch_assoc(mysqli_query($db_link,
                "SELECT COALESCE(SUM(sav_amount), 0) AS balance 
                 FROM savings 
                 WHERE cust_id = '{$customer['cust_id']}'"
            ));

            $sms = "Dear {$customer['cust_name']}, " .
                   "Loan #: {$loan['loan_no']} is fully paid.  " .
                   number_format($amount) . " TSH has been processed to Jamii. " .
                   "New Jamii balance: " . number_format($savings['balance']) . " TSH. $companyName";
        }
    } else {
        // Case 3: No qualifying loan
        mysqli_query($db_link,
            "INSERT INTO savings (
                cust_id, sav_date, sav_amount, 
                savtype_id, sav_receipt, sav_created, user_id
             ) VALUES (
                '{$customer['cust_id']}', $timestamp, $amount,
                1, '$receipt', $timestamp, 1
             )"
        );

        // Get updated savings balance
        $savings = mysqli_fetch_assoc(mysqli_query($db_link,
            "SELECT COALESCE(SUM(sav_amount), 0) AS balance 
             FROM savings 
             WHERE cust_id = '{$customer['cust_id']}'"
        ));

        $sms = "Dear {$customer['cust_name']}, your jamii payment of  " .
               number_format($amount) . " TSH has been processed. " .
               "New Jamii balance: " . number_format($savings['balance']) . " TSH. $companyName";
    }

    // 7. Send SMS notification
    sendSMS($phoneNumber, $sms, $db_link);
}
?>
