class LoanModel {
    protected $db;
    
    public function __construct($db) {
        $this->db = $db;
    }
    
    public function getLoanDetails($loan_id) {
        $stmt = $this->db->prepare("
            SELECT l.*, c.cust_name, c.cust_phone, ls.loanstatus_status 
            FROM loans l
            JOIN customer c ON l.cust_id = c.cust_id
            JOIN loanstatus ls ON l.loanstatus_id = ls.loanstatus_id
            WHERE l.loan_id = ?
        ");
        $stmt->bind_param("i", $loan_id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }
    
    public function getUnpaidInstallments($loan_id) {
        $stmt = $this->db->prepare("
            SELECT * FROM ltrans 
            WHERE loan_id = ? 
            AND ltrans_date IS NULL 
            AND ltrans_due IS NOT NULL
            ORDER BY ltrans_due ASC
        ");
        $stmt->bind_param("i", $loan_id);
        $stmt->execute();
        return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    }
    
    public function recordPayment($payment_data) {
        // Begin transaction
        $this->db->begin_transaction();
        
        try {
            // Update installment record
            $stmt = $this->db->prepare("
                UPDATE ltrans SET 
                ltrans_date = ?,
                ltrans_principal = ?,
                ltrans_interest = ?,
                ltrans_receipt = ?,
                user_id = ?
                WHERE ltrans_id = ?
            ");
            $stmt->bind_param("iidsii", 
                $payment_data['payment_date'],
                $payment_data['principal_paid'],
                $payment_data['interest_paid'],
                $payment_data['receipt_no'],
                $payment_data['user_id'],
                $payment_data['ltrans_id']
            );
            $stmt->execute();
            
            // Record interest income if any
            if ($payment_data['interest_paid'] > 0) {
                $stmt = $this->db->prepare("
                    INSERT INTO incomes 
                    (cust_id, inctype_id, ltrans_id, inc_amount, inc_date, inc_receipt, user_id)
                    VALUES (?, 4, ?, ?, ?, ?, ?)
                ");
                $stmt->bind_param("iiisii",
                    $payment_data['cust_id'],
                    $payment_data['ltrans_id'],
                    $payment_data['interest_paid'],
                    $payment_data['payment_date'],
                    $payment_data['receipt_no'],
                    $payment_data['user_id']
                );
                $stmt->execute();
            }
            
            // Commit transaction
            $this->db->commit();
            return true;
        } catch (Exception $e) {
            $this->db->rollback();
            return false;
        }
    }
    
    // Other necessary methods...
}