// Initialize
require 'loan_model.php';
require 'payment_service.php';

$db = connect(); // Your database connection function
$model = new LoanModel($db);
$service = new PaymentService($model);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['make_payment'])) {
    $payment_data = [
        'amount' => (float)$_POST['amount'],
        'payment_date' => strtotime($_POST['payment_date']),
        'receipt_no' => $_POST['receipt_no'],
        'user_id' => $_SESSION['log_id']
    ];
    
    $result = $service->processPayment($_SESSION['loan_id'], $payment_data);
    
    // Prepare user feedback
    if ($result['processed_installments'] > 0) {
        $_SESSION['message'] = sprintf(
            "Successfully processed payment covering %d installments (%s principal + %s interest)",
            $result['processed_installments'],
            format_currency($result['total_principal']),
            format_currency($result['total_interest'])
        );
        
        if ($result['remaining_amount'] > 0) {
            if ($result['fully_paid']) {
                $_SESSION['message'] .= sprintf(
                    "<br>Excess amount of %s was credited to savings.",
                    format_currency($result['remaining_amount'])
                );
            } else {
                $_SESSION['message'] .= sprintf(
                    "<br>Note: %s was not applied (not enough to cover next installment).",
                    format_currency($result['remaining_amount'])
                );
            }
        }
    } else {
        $_SESSION['error'] = "Payment could not be processed. Please check the amount and try again.";
    }
    
    header("Location: loan.php?lid=".$_SESSION['loan_id']);
    exit;
}

// Display payment form
$loan = $model->getLoanDetails($_SESSION['loan_id']);
$installments = $model->getUnpaidInstallments($_SESSION['loan_id']);
$next_due = !empty($installments) ? date("d.m.Y", $installments[0]['ltrans_due']) : 'None';
$min_payment = !empty($installments) ? 
    ($installments[0]['ltrans_principaldue'] + $installments[0]['ltrans_interestdue']) : 0;
?>

<!-- Payment Form -->
<div class="payment-form">
    <h3>Make Payment</h3>
    
    <?php if (!empty($installments)): ?>
    <form method="post">
        <div class="form-group">
            <label>Next Due Date:</label>
            <span><?= $next_due ?></span>
        </div>
        
        <div class="form-group">
            <label>Payment Amount (<?= $_SESSION['set_cur'] ?>):</label>
            <input type="number" name="amount" min="<?= $min_payment ?>" 
                   step="0.01" required value="<?= $min_payment ?>">
            <small>Minimum: <?= format_currency($min_payment) ?></small>
        </div>
        
        <div class="form-group">
            <label>Payment Date:</label>
            <input type="text" name="payment_date" class="datepicker" 
                   value="<?= date("d.m.Y") ?>">
        </div>
        
        <div class="form-group">
            <label>Receipt Number:</label>
            <input type="text" name="receipt_no" required>
        </div>
        
        <div class="form-group">
            <button type="submit" name="make_payment">Process Payment</button>
        </div>
        
        <div class="payment-help">
            <p>Payments are automatically applied to the oldest unpaid installments first.</p>
            <p>Enter a larger amount to pay multiple installments at once.</p>
        </div>
    </form>
    <?php else: ?>
    <div class="alert alert-success">
        This loan has no unpaid installments.
    </div>
    <?php endif; ?>
</div>