<?php
session_start();
require 'functions.php';
checkLogin();
$db_link = connect();

// Check if loan ID is provided
if (!isset($_GET['lid'])) {
    die("Loan ID is required.");
}

$loan_id = $_GET['lid'];

// Fetch loan details with total shares
$sql_loan = "SELECT 
                loans.*, 
                customer.*, 
                loanstatus.*, 
                COALESCE(SUM(shares.share_amount), 0) AS total_shares
             FROM loans 
             LEFT JOIN customer ON loans.cust_id = customer.cust_id 
             LEFT JOIN loanstatus ON loans.loanstatus_id = loanstatus.loanstatus_id 
             LEFT JOIN shares ON loans.cust_id = shares.cust_id 
             WHERE loans.loan_id = '$loan_id'
             GROUP BY loans.loan_id";
$query_loan = mysqli_query($db_link, $sql_loan);
checkSQL($db_link, $query_loan);

if (mysqli_num_rows($query_loan) == 0) {
    die("Loan not found.");
}

$row_loan = mysqli_fetch_assoc($query_loan);

// Calculate total share value (total shares * 20,000)
$total_share_value = $row_loan['total_shares'] * 20000;

// Calculate monthly installments
$loan_no =  $row_loan['loan_no'];
$loan_principal = $row_loan['loan_principal'];
$loan_interest = $row_loan['loan_repaytotal'] - $row_loan['loan_principal']; // Interest is the difference between repay total and principal
$loan_duration = $row_loan['loan_period']; // Loan duration in months
$total_loan_balance = $loan_principal + $loan_interest; // Total loan balance

// Calculate loan rate percentage
$loan_rate_percentage = ($loan_interest / $loan_principal) * 100;

$monthly_installment = $total_loan_balance / $loan_duration;

// Generate loan repayment schedule with dates
$repayment_schedule = [];
$remaining_balance = $total_loan_balance;
$loan_start_date = ($row_loan['loan_date'] > 0) ? date('Y-m-d', $row_loan['loan_date']) : date('Y-m-d'); // Fallback to current date if invalid

for ($i = 1; $i <= $loan_duration; $i++) {
    $repayment_date = date('d.m.Y', strtotime("+$i months", strtotime($loan_start_date)));
    $repayment_schedule[] = [
        'month' => $i,
        'installment' => $monthly_installment,
        'remaining_balance' => $remaining_balance - $monthly_installment,
        'repayment_date' => $repayment_date
    ];
    $remaining_balance -= $monthly_installment;
}

// Convert loan request date from Unix format to readable format
$loan_request_date = ($row_loan['loan_date'] > 0) ? date('d.m.Y', $row_loan['loan_date']) : 'N/A';

// Fetch members in the same group as the current member
$group_members_sql = "SELECT 
    c.cust_name, 
    c.cust_id, 
    c.cust_no,
    la.code,
    la.status,
    la.responded_at
FROM 
    customer c
LEFT JOIN 
    loan_approvals la ON c.cust_id = la.member_id AND la.loan_id = '{$row_loan['loan_id']}'
WHERE 
    c.cust_group = '{$row_loan['cust_group']}'";

$group_members_query = mysqli_query($db_link, $group_members_sql);
checkSQL($db_link, $group_members_query);
$group_members = mysqli_fetch_all($group_members_query, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="robots" content="noindex, nofollow">
    <title>NES | Loan Request Form</title>
    <link rel="shortcut icon" href="ico/favicon.ico" type="image/x-icon">

    <!-- Print-specific styles -->
    <style>
        /* General styles */
        body {
            font-family: Arial, sans-serif;
            font-size: 18px; /* Increased base font size */
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 18px; /* Increased table font size */
        }

        th, td {
            border: 1px solid #000;
            padding: 12px; /* Increased padding for better spacing */
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            font-size: 20px; /* Increased header font size */
        }

        .form-title {
            text-align: center;
            font-size: 32px; /* Increased title font size */
            font-weight: bold;
            margin-bottom: 20px;
        }

        .terms {
            margin-top: 20px;
            padding: 15px;
            border: 1px solid #ddd;
            background-color: #f9f9f9;
            font-size: 18px; /* Increased terms font size */
        }

        .terms h3 {
            margin-top: 0;
            font-size: 22px; /* Increased terms heading font size */
        }

        .terms ul {
            padding-left: 20px;
        }

        .terms ul li {
            margin-bottom: 10px;
        }

        /* Print-specific styles */
        @media print {
            body, html {
                margin: 0 !important;
                padding: 0 !important;
                font-size: 20px; /* Increased font size for print */
            }

            .content-center {
                margin: 0;
                padding: 0;
            }

            #menu_main, button {
                display: none;
            }

            .repayment-schedule {
                page-break-inside: avoid; /* Prevent splitting the table across pages */
            }

            table {
                font-size: 20px; /* Increased table font size for print */
            }

            th {
                font-size: 22px; /* Increased header font size for print */
            }

            .form-title {
                font-size: 36px; /* Increased title font size for print */
            }

            .terms {
                font-size: 20px; /* Increased terms font size for print */
            }

            .terms h3 {
                font-size: 24px; /* Increased terms heading font size for print */
            }
        }

        button {
            font-size: 18px; /* Increased button font size */
            padding: 12px 24px; /* Increased button padding */
            margin: 10px;
            cursor: pointer;
        }
    </style>
    <!-- Include html2pdf library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    <script>
        function printToPDF() {
            const element = document.getElementById('loan-form');
            const options = {
                margin: [10, 10, 10, 10], // Margins: top, right, bottom, left
                filename: 'NUFAIKA_LOAN_REQUEST_FORM.pdf',
                image: { type: 'jpeg', quality: 0.98 },
                html2canvas: { scale: 2 },
                jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
            };
            html2pdf()
                .set(options)
                .from(element)
                .save();
        }
    </script>
</head>
<body>
    <div class="content-center" id="loan-form" style="width: 80%; height: 40%; padding: 2%;">
        <div class="form-title">NUFAIKA LOAN REQUEST FORM</div>
        <table>
            <tr>
                <th colspan="2">Member Details</th>
            </tr>
            <tr>
                <td>Member Picture</td>
                <td>
                    <?php if (!empty($row_loan['cust_pic'])): ?>
                        <img src="<?php echo $row_loan['cust_pic']; ?>" alt="Member Picture" width="200">
                    <?php else: ?>
                        No Picture Available
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <td>Member ID</td>
                <td><?php echo $row_loan['cust_no']; ?></td>
            </tr>
            <tr>
                <td>Name</td>
                <td><?php echo $row_loan['cust_name']; ?></td>
            </tr>
            <tr>
                <td>Address</td>
                <td><?php echo $row_loan['cust_address']; ?></td>
            </tr>
            <tr>
                <td>Phone Number</td>
                <td><?php echo $row_loan['cust_phone']; ?></td>
            </tr>
            <tr>
                <td>Group</td>
                <td><?php echo $row_loan['cust_group']; ?></td>
            </tr>
            <tr>
                <td>Shares</td>
                <td><?php echo number_format($row_loan['total_shares'] ?? 0); ?></td>
            </tr>
            <tr>
                <td>Total Share Value</td>
                <td><?php echo number_format($total_share_value); ?> <?php echo $_SESSION['set_cur']; ?></td>
            </tr>
            <tr>
                <th colspan="2">Loan Particulars</th>
            </tr>
             <tr>
        <td>Loan ID</td>
        <td><?php echo $loan_no; ?></td>
    </tr>
            <tr>
                <td>Loan Amount</td>
                <td><?php echo number_format($row_loan['loan_principal']); ?> <?php echo $_SESSION['set_cur']; ?></td>
            </tr>
            <tr>
                <td>Interest</td>
                <td><?php echo number_format($loan_interest); ?> <?php echo $_SESSION['set_cur']; ?></td>
            </tr>
            <tr>
                <td>Loan Rate (%)</td>
                <td><?php echo number_format($loan_rate_percentage, 2); ?>%</td>
            </tr>
            <tr>
                <td>Total Loan Repayment Amount</td>
                <td><?php echo number_format($total_loan_balance); ?> <?php echo $_SESSION['set_cur']; ?></td>
            </tr>
            <tr>
                <td>Loan Period</td>
                <td><?php echo $row_loan['loan_period']; ?> months</td>
            </tr>
            <tr>
                <td>Monthly Installment</td>
                <td><?php echo number_format($monthly_installment, 2); ?> <?php echo $_SESSION['set_cur']; ?></td>
            </tr>
            <tr>
                <td>Loan Request Date</td>
                <td><?php echo $loan_request_date; ?></td>
            </tr>
        </table>

        <!-- Members in the Same Group -->
        <table>
            <tr>
                <th colspan="4">Group Members Approval</th>
            </tr>
            <tr>
                <th>Member ID</th>
                <th>Name</th>
                <th>Status</th>
                <th>Date</th>
            </tr>
            <?php foreach ($group_members as $member): ?>
                <tr>
                    <td><?php echo $member['cust_no']; ?></td>
                    <td><?php echo $member['cust_name']; ?></td>
                    <td><?php echo $member['status']; ?></td>
                    <td><?php echo $member['responded_at']; ?></td>
                </tr>
            <?php endforeach; ?>
        </table>

        <!-- Loan Repayment Schedule -->
        <table class="repayment-schedule">
            <tr>
                <th colspan="4">Loan Repayment Schedule</th>
            </tr>
            <tr>
                <th>Month</th>
                <th>Installment</th>
                <th>Repayment Date</th>
                <th>Remaining Balance</th>
            </tr>
            <?php foreach ($repayment_schedule as $schedule): ?>
                <tr>
                    <td><?php echo $schedule['month']; ?></td>
                    <td><?php echo number_format($schedule['installment'], 2); ?> <?php echo $_SESSION['set_cur']; ?></td>
                    <td><?php echo $schedule['repayment_date']; ?></td>
                    <td><?php echo number_format($schedule['remaining_balance'], 2); ?> <?php echo $_SESSION['set_cur']; ?></td>
                </tr>
            <?php endforeach; ?>
        </table>

        <!-- Loan Terms and Conditions -->
        <div class="terms">
            <h3>Loan Terms and Conditions</h3>
            <ul>
                <li>The borrower must make monthly loan repayments.</li>
                <li>By signing above each member of the group takes responsibility of the loan.</li>
                <li>If the borrower fails to make the monthly repayment for a given month, they will be required to pay a penalty fee of 10% of the monthly installment.</li>
                <li>If the borrower does not repay the loan within the agreed period, the loan may be restructured with a new interest rate, and the member will not be allowed to borrow again until they fully repay the loan along with the interest.</li>
                <li>The guarantor group (the group the member originates from) and the borrower are both responsible for ensuring that the loan is repaid on time.</li>
                <li>The borrower must be guaranteed by a guarantor group. If the member fails to clear the loan, the guarantor group will be responsible.</li>
            </ul>
        </div>

        <!-- Signatures -->
        <table>
            <tr>
                <th colspan="3">Signatures</th>
            </tr>
            <tr>
                <td>Borowing Member Signature</td>
                <td>.......................................</td>
                <td>Date: .......................................</td>
            </tr>
                   <tr>
                <td>Secretary Signature</td>
                <td>.......................................</td>
                <td>Date: .......................................</td>
            </tr>
            <tr>
                <td>Accountant Signature</td>
                <td>.......................................</td>
                <td>Date: .......................................</td>
            </tr>
            <tr>
                <td>Chairperson Signature</td>
                <td>.......................................</td>
                <td>Date: .......................................</td>
            </tr>
        
        </table>

        <br>
        <button onclick="window.print()">Print Form</button>
    </div>
</body>
</html>