<?php
session_start();
require 'functions.php';
// checkLogin();
// checkPermissionReport();
$db_link = connect();

// Fetch financial start and end months from the date_settings table
$financialMonthsQuery = "SELECT variable_name, variable_value FROM date_settings WHERE variable_name IN ('financial_start_month', 'financial_end_month')";
$financialMonthsResult = mysqli_query($db_link, $financialMonthsQuery);

if (!$financialMonthsResult) {
    die("Failed to fetch financial months: " . mysqli_error($db_link));
}

$financialMonths = [];
while ($row = mysqli_fetch_assoc($financialMonthsResult)) {
    $financialMonths[$row['variable_name']] = (int)$row['variable_value'];
}

// Get the selected month and year from the form submission
$selected_month = isset($_POST['month']) ? (int)$_POST['month'] : date('n');
$selected_year = isset($_POST['year']) ? (int)$_POST['year'] : date('Y');

// Calculate the first and last day of the selected month
$firstDay = mktime(0, 0, 0, $selected_month, 1, $selected_year);
$lastDay = mktime(23, 59, 59, $selected_month, date("t", $firstDay), $selected_year);

// Calculate the financial year start and end dates
$financialStartMonth = $financialMonths['financial_start_month'];
$financialEndMonth = $financialMonths['financial_end_month'];

if ($selected_month >= $financialStartMonth) {
    // Financial year started in the current year
    $financialStartYear = $selected_year;
    $financialEndYear = $selected_year + 1;
} else {
    // Financial year started in the previous year
    $financialStartYear = $selected_year - 1;
    $financialEndYear = $selected_year;
}

$financial_start_date = mktime(0, 0, 0, $financialStartMonth, 1, $financialStartYear);
$financial_end_date = mktime(23, 59, 59, $financialEndMonth, 31, $financialEndYear);

// Financial Year Data for Widgets
$rep_year_start = date('Y');
$rep_year = date('Y');
$firstDay_loan = mktime(0, 0, 0, 8, 1, 2024); //starting date loan counter
$lastDay_loan = mktime(0, 0, 0, 7, 31, 2025); //ending date loan counter


// Fetch the company name and share value using the functions
$companyName = getCompanyName($db_link);
$shareValue = getCurrentShareValue($db_link);

// Fetch data for the report
$sql = "-- Step 1: Calculate the total income for the financial period 
WITH TotalIncome AS (
    SELECT 
        IFNULL(SUM(i.inc_amount), 0) AS total_income
    FROM incomes i
    WHERE i.inc_date BETWEEN $financial_start_date AND $financial_end_date
),

-- Step 2: Calculate the total shares of eligible customers
EligibleShares AS (
    SELECT 
        IFNULL(SUM(s.share_amount), 0) AS total_shares,
        COUNT(DISTINCT s.cust_id) AS eligible_members_count
    FROM shares s
    WHERE s.cust_id IN (
        -- Members who qualify via loan repayments
        SELECT l.cust_id
        FROM loans l
        WHERE l.loan_date BETWEEN $financial_start_date AND $financial_end_date
        GROUP BY l.cust_id
        HAVING SUM(l.loan_repaytotal) > 2400000
        
        UNION
        
        -- Members who qualify via income
        SELECT i.cust_id
        FROM incomes i
        WHERE i.inc_date BETWEEN $financial_start_date AND $financial_end_date
          AND i.inctype_id = 4  -- Assuming 4 is interest income
        GROUP BY i.cust_id
        HAVING SUM(i.inc_amount) > 200000
    )
    AND s.share_date <= $financial_end_date  -- Only shares purchased before FY end
),

-- Step 3: Calculate the share value
ShareValue AS (
    SELECT 
        (SELECT total_income FROM TotalIncome) / 
        (SELECT total_shares FROM EligibleShares) AS share_value
),

-- Step 4: Calculate PVE for each loan (WITH DATE FILTER)
LoanPVE AS (
    SELECT 
        l.cust_id,
        l.loan_id,
        IFNULL(SUM(lt.ltrans_principal + lt.ltrans_interest), 0) AS loan_paid,
        (l.loan_repaytotal / l.loan_period) AS loan_expected,
        IFNULL(
            (SUM(lt.ltrans_principal + lt.ltrans_interest) / NULLIF((l.loan_repaytotal / l.loan_period), 0)) * 100, 0
        ) AS loan_pve
    FROM loans l
    LEFT JOIN ltrans lt ON l.loan_id = lt.loan_id
    WHERE l.loanstatus_id = 2 -- Active loans
      AND lt.ltrans_date BETWEEN $firstDay AND $lastDay -- Critical fix: Filter payments to the current month
    GROUP BY l.loan_id, l.cust_id, l.loan_repaytotal, l.loan_period
),

-- Step 5: Calculate remaining installments and monthly installment for each loan (ignoring current month's payments)
LoanRemaining AS (
    SELECT 
        l.cust_id,
        l.loan_id,
        l.loan_repaytotal,
        l.loan_period,
        FROM_UNIXTIME(l.loan_date) AS loan_date, -- Convert Unix timestamp to MySQL date
        DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH) AS loan_enddate, -- Dynamically calculate loan_enddate
        GREATEST(
            (YEAR(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - YEAR(CURDATE())) * 12 + 
            (MONTH(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - MONTH(CURDATE())) +0 , 
            1
        ) AS remaining_installments, -- Ensure at least 1 installment
        (l.loan_repaytotal - IFNULL(SUM(CASE WHEN lt.ltrans_date NOT BETWEEN $firstDay AND $lastDay THEN lt.ltrans_principal + lt.ltrans_interest ELSE 0 END), 0)) AS remaining_balance, -- Exclude current month's payments
        (l.loan_repaytotal - IFNULL(SUM(CASE WHEN lt.ltrans_date NOT BETWEEN $firstDay AND $lastDay THEN lt.ltrans_principal + lt.ltrans_interest ELSE 0 END), 0)) / 
        GREATEST(
            (YEAR(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - YEAR(CURDATE())) * 12 + 
            (MONTH(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - MONTH(CURDATE())) + 1, 
            1
        ) AS monthly_installment -- Ensure at least 1 installment
    FROM loans l
    LEFT JOIN ltrans lt ON l.loan_id = lt.loan_id
    WHERE l.loanstatus_id = 2 -- Active loans
    GROUP BY l.loan_id, l.cust_id, l.loan_repaytotal, l.loan_period, l.loan_date
)

-- Step 6: Main query to fetch customer data and calculate dividends
SELECT 
    c.cust_id,
    c.cust_name,
    c.cust_group,
    -- Total Share up to the selected month
    (SELECT IFNULL(SUM(s.share_amount), 0) 
     FROM shares s 
     WHERE s.cust_id = c.cust_id 
       AND s.share_date <= $lastDay) AS total_share, -- Filter shares up to the selected month

    -- Total Share Value up to the selected month (multiplied by share value)
    (SELECT IFNULL(SUM(s.share_amount), 0) 
     FROM shares s 
     WHERE s.cust_id = c.cust_id 
       AND s.share_date <= $lastDay) * $shareValue AS total_share_value, -- Filter shares up to the selected month

    -- Shares Current Month (multiplied by share value)
    (SELECT IFNULL(SUM(s.share_amount), 0) 
     FROM shares s 
     WHERE s.cust_id = c.cust_id 
       AND s.share_date BETWEEN $firstDay AND $lastDay) * $shareValue AS shares_current_month,

    -- Jamii Current Month (savings deposited in the current month)
    (SELECT IFNULL(SUM(sv.sav_amount), 0) 
     FROM savings sv 
     WHERE sv.cust_id = c.cust_id 
       AND sv.sav_date BETWEEN $firstDay AND $lastDay) AS jamii_current_month,

    -- Jamii Loans (0% interest)
    (SELECT IFNULL(SUM(l.loan_repaytotal / l.loan_period), 0) 
     FROM loans l 
     WHERE l.cust_id = c.cust_id 
       AND l.loanstatus_id = 2 
       AND l.loan_interest = 0) AS jamii_expected_monthly_instalment,

    -- Normal Loans (with interest)
    (SELECT IFNULL(SUM(lr.monthly_installment), 0) 
     FROM LoanRemaining lr 
     WHERE lr.cust_id = c.cust_id) AS monthly_installment,

    (SELECT IFNULL(SUM(lt.ltrans_principal + lt.ltrans_interest), 0) 
     FROM ltrans lt 
     WHERE lt.loan_id IN (SELECT l.loan_id 
                          FROM loans l 
                          WHERE l.cust_id = c.cust_id 
                            AND l.loanstatus_id = 2 
                            AND l.loan_interest > 0) 
       AND lt.ltrans_date BETWEEN $firstDay AND $lastDay) AS normal_paid_monthly_instalment,

    -- Remaining Loan Balance (using LoanRemaining CTE)
    (SELECT IFNULL(SUM(lr.remaining_balance), 0) 
     FROM LoanRemaining lr 
     WHERE lr.cust_id = c.cust_id) AS remaining_loan_balance,

    -- PVE Percentage (Portfolio at Risk) - Loan-specific aggregation
    IFNULL(
        (SELECT AVG(loan_pve) 
         FROM LoanPVE lp 
         WHERE lp.cust_id = c.cust_id), 0
    ) AS pve_percentage,

    -- Share Value (from the CTE)
    (SELECT share_value FROM ShareValue) AS share_value,

    -- Dividends (shares * share value) ONLY FOR ELIGIBLE CUSTOMERS
    CASE
        WHEN 
            (SELECT IFNULL(SUM(l.loan_repaytotal), 0) 
             FROM loans l 
             WHERE l.cust_id = c.cust_id 
               AND l.loan_date BETWEEN $financial_start_date AND $financial_end_date) > 2400000
            OR 
            (SELECT IFNULL(SUM(i2.inc_amount), 0) 
             FROM incomes i2 
             WHERE i2.cust_id = c.cust_id 
               AND i2.inc_date BETWEEN $financial_start_date AND $financial_end_date 
               AND i2.inctype_id = 4) > 200000
        THEN 
            (SELECT IFNULL(SUM(s.share_amount), 0) 
             FROM shares s 
             WHERE s.cust_id = c.cust_id 
               AND s.share_date <= $financial_end_date) * (SELECT share_value FROM ShareValue) -- Filter shares up to the selected month
        ELSE 
            0
    END AS dividends
FROM 
    customer c
LEFT JOIN 
    LoanPVE lp ON c.cust_id = lp.cust_id
LEFT JOIN 
    LoanRemaining lr ON c.cust_id = lr.cust_id
WHERE 
    c.cust_group IS NOT NULL -- Exclude members with NULL group values
GROUP BY 
    c.cust_id
ORDER BY 
    c.cust_group, c.cust_name;";

$query = mysqli_query($db_link, $sql);
checkSQL($db_link, $query);

// Initialize totals
$grand_total_share = 0;
$grand_total_share_value = 0;
$grand_total_shares_current_month = 0;
$grand_total_jamii_current_month = 0;
$grand_total_jamii_expected_monthly_instalment = 0;
$grand_total_monthly_installment = 0; // Updated variable
$grand_total_normal_paid_monthly_instalment = 0;
$grand_total_normal_remaining_monthly_instalment = 0;
$grand_total_remaining_loan_balance = 0;
$grand_total_pve = 0;
$grand_total_dividends = 0;
$grand_count = 0; // For calculating average PVE


// Select Share Value 
$sql_default_share = "SELECT shareval_value FROM `shareval` ORDER BY shareval_value DESC LIMIT 1";
$query_default_share = mysqli_query($db_link, $sql_default_share);
checkSQL($db_link, $query_default_share);
$default_share = 0;
while($row_default_share = mysqli_fetch_assoc($query_default_share)){
    $default_share = $row_default_share['shareval_value'];
}

// Select total income
$sql_incomes_total = "SELECT * FROM incomes WHERE inc_date BETWEEN $financial_start_date AND $financial_end_date";
$query_incomes_total = mysqli_query($db_link, $sql_incomes_total);
checkSQL($db_link, $query_incomes_total);
$total_incomes = 0;
while($row_incomes_total = mysqli_fetch_assoc($query_incomes_total)){
    $total_incomes = $total_incomes + $row_incomes_total['inc_amount'];
}

// Select total incomes ALL
$sql_incomes_total_fixed = "SELECT * FROM incomes";
$query_incomes_total_fixed = mysqli_query($db_link, $sql_incomes_total_fixed);
checkSQL($db_link, $query_incomes_total_fixed);
$total_incomes_fixed = 0;
while($row_incomes_total_fixed = mysqli_fetch_assoc($query_incomes_total_fixed)){
    $total_incomes_fixed = $total_incomes_fixed + $row_incomes_total_fixed['inc_amount'];
}

// Select other incomes excluding interests 
$sql_incomes_others = "SELECT * FROM incomes WHERE inc_date BETWEEN $financial_start_date AND $financial_end_date AND inctype_id !='4'";
$query_incomes_others = mysqli_query($db_link, $sql_incomes_others);
checkSQL($db_link, $query_incomes_others);
$total_incomes_others = 0;
while($row_incomes_others = mysqli_fetch_assoc($query_incomes_others)){
    $total_incomes_others = $total_incomes_others + $row_incomes_others['inc_amount'];
}

// Select other incomes fixed from start excluding interests 
$sql_incomes_others_fixed = "SELECT * FROM incomes WHERE inctype_id !='4'";
$query_incomes_others_fixed = mysqli_query($db_link, $sql_incomes_others_fixed);
checkSQL($db_link, $query_incomes_others_fixed);
$total_incomes_others_fixed = 0;
while($row_incomes_others_fixed = mysqli_fetch_assoc($query_incomes_others_fixed)){
    $total_incomes_others_fixed = $total_incomes_others_fixed + $row_incomes_others_fixed['inc_amount'];
}

// Select expenses (dividends)
$sql_expendit_dividends = "SELECT * FROM expenses WHERE exp_date BETWEEN $financial_start_date AND $financial_end_date AND exptype_id =18";
$query_expendit_dividends = mysqli_query($db_link, $sql_expendit_dividends);
checkSQL($db_link, $query_expendit_dividends);
$total_expendit_dividends = 0;
while($row_expendit_dividends = mysqli_fetch_assoc($query_expendit_dividends)){
    $total_expendit_dividends = $total_expendit_dividends + $row_expendit_dividends['exp_amount'];
}

// Select expenses (dividends fixed)
$sql_expendit_dividends_fixed = "SELECT * FROM expenses WHERE exptype_id =18";
$query_expendit_dividends_fixed = mysqli_query($db_link, $sql_expendit_dividends_fixed);
checkSQL($db_link, $query_expendit_dividends_fixed);
$total_expendit_dividends_fixed = 0;
while($row_expendit_dividends_fixed = mysqli_fetch_assoc($query_expendit_dividends_fixed)){
    $total_expendit_dividends_fixed = $total_expendit_dividends_fixed + $row_expendit_dividends_fixed['exp_amount'];
}

// Select expenses (others apart from dividends)
$sql_expendit_others = "SELECT * FROM expenses WHERE exp_date BETWEEN $financial_start_date AND $financial_end_date AND exptype_id !=18";
$query_expendit_others = mysqli_query($db_link, $sql_expendit_others);
checkSQL($db_link, $query_expendit_others);
$total_expendit_others = 0;
while($row_expendit_others = mysqli_fetch_assoc($query_expendit_others)){
    $total_expendit_others = $total_expendit_others + $row_expendit_others['exp_amount'];
}

// Select expenses (others apart from dividends fixed)
$sql_expendit_others_fixed = "SELECT * FROM expenses WHERE exptype_id !=18";
$query_expendit_others_fixed = mysqli_query($db_link, $sql_expendit_others_fixed);
checkSQL($db_link, $query_expendit_others_fixed);
$total_expendit_others_fixed = 0;
while($row_expendit_others_fixed = mysqli_fetch_assoc($query_expendit_others_fixed)){
    $total_expendit_others_fixed = $total_expendit_others_fixed + $row_expendit_others_fixed['exp_amount'];
}

// Select bought and sold Shares from SHARES
$sql_shares = "SELECT * FROM shares WHERE share_date BETWEEN $financial_start_date AND $financial_end_date";
$query_shares = mysqli_query($db_link, $sql_shares);
checkSQL($db_link, $query_shares);
$total_share_buys = 0;
$total_share_sales = 0;
while($row_shares = mysqli_fetch_assoc($query_shares)){
    if($row_shares['share_amount'] >= 0){
        $total_share_buys = $total_share_buys + $row_shares['share_value'];
    }
    elseif($row_shares['share_amount'] < 0){
        $total_share_sales = $total_share_sales + $row_shares['share_value'] * (-1);
    }
}

// Total shares FY
$sql_shares_total = "SELECT * FROM shares WHERE share_date BETWEEN $financial_start_date AND $financial_end_date";
$query_shares_total = mysqli_query($db_link, $sql_shares_total);
checkSQL($db_link, $query_shares_total);
$total_shares = 0;
while($row_total_shares = mysqli_fetch_assoc($query_shares_total)){
    $total_shares = $total_shares + $row_total_shares['share_amount'];
}

// Total shares Fixed
$sql_shares_total_fixed = "SELECT * FROM shares ";
$query_shares_total_fixed = mysqli_query($db_link, $sql_shares_total_fixed);
checkSQL($db_link, $query_shares_total_fixed);
$total_shares_fixed = 0;
while($row_total_shares_fixed = mysqli_fetch_assoc($query_shares_total_fixed)){
    $total_shares_fixed = $total_shares_fixed + $row_total_shares_fixed['share_amount'];
}

//TOtal shares value 
$sql_shares_total_value = "SELECT * FROM shares";
$query_shares_total_value = mysqli_query($db_link, $sql_shares_total_value);
checkSQL($db_link, $query_shares_total_value);
$total_shares_value = 0;
while($row_total_shares_value = mysqli_fetch_assoc($query_shares_total_value)){
    $total_shares_value = $total_shares_value + $row_total_shares_value['share_value'];
}

//TOtal shares value FY
$sql_shares_total_value_fixed = "SELECT * FROM shares WHERE share_date BETWEEN $financial_start_date AND $financial_end_date";
$query_shares_total_value_fixed = mysqli_query($db_link, $sql_shares_total_value_fixed);
checkSQL($db_link, $query_shares_total_value_fixed);
$total_shares_value_fixed = 0;
while($row_total_shares_value_fixed = mysqli_fetch_assoc($query_shares_total_value_fixed)){
    $total_shares_value_fixed = $total_shares_value_fixed + $row_total_shares_value_fixed['share_value'];
}

// Select Saving Deposits from SAVINGS
$sql_savdep = "SELECT * FROM savings WHERE sav_date BETWEEN $financial_start_date AND $financial_end_date AND savtype_id = 1";
$query_savdep = mysqli_query($db_link, $sql_savdep);
checkSQL($db_link, $query_savdep);
$total_savdep = 0;
while($row_savdep = mysqli_fetch_assoc($query_savdep)){
    $total_savdep = $total_savdep + $row_savdep['sav_amount'];
}

// Select Saving Deposits from SAVINGS
$sql_savdep_fixed = "SELECT * FROM savings WHERE savtype_id = 1";
$query_savdep_fixed = mysqli_query($db_link, $sql_savdep_fixed);
checkSQL($db_link, $query_savdep_fixed);
$total_savdep_fixed = 0;
while($row_savdep_fixed = mysqli_fetch_assoc($query_savdep_fixed)){
    $total_savdep_fixed = $total_savdep_fixed + $row_savdep_fixed['sav_amount'];
}

// Select Loan Recoveries from LOANS
// Select Loan Recoveries (Principal + Interest) from LTRANS
$sql_loanrec = "SELECT 
                SUM(ltrans_principal) AS total_principal_recovered,
                SUM(ltrans_interest) AS total_interest_recovered,
                SUM(ltrans_principal + ltrans_interest) AS total_recovered
                FROM ltrans
                JOIN loans ON ltrans.loan_id = loans.loan_id
                WHERE ltrans.ltrans_date BETWEEN '$financial_start_date' AND '$financial_end_date'
                AND loans.loanstatus_id IN (2, 4, 5)";

$query_loanrec = mysqli_query($db_link, $sql_loanrec);
checkSQL($db_link, $query_loanrec);

$row_loanrec = mysqli_fetch_assoc($query_loanrec);
$total_principal_recovered = $row_loanrec['total_principal_recovered'] ?? 0;
$total_interest_recovered = $row_loanrec['total_interest_recovered'] ?? 0;
$total_loanrec = $row_loanrec['total_recovered'] ?? 0;

// Select Loan Recoveries from LOANS ALL
$sql_loanrec_fixed = "SELECT 
                SUM(ltrans_principal) AS total_principal_recovered,
                SUM(ltrans_interest) AS total_interest_recovered,
                SUM(ltrans_principal + ltrans_interest) AS total_recovered
                FROM ltrans
                JOIN loans ON ltrans.loan_id = loans.loan_id
                AND loans.loanstatus_id IN (2, 4, 5)
                AND loans.loan_interest > 0 ";

$query_loanrec_fixed = mysqli_query($db_link, $sql_loanrec_fixed);
checkSQL($db_link, $query_loanrec_fixed);

$row_loanrec_fixed = mysqli_fetch_assoc($query_loanrec_fixed);
$total_principal_recovered_fixed = $row_loanrec_fixed['total_principal_recovered'] ?? 0;
$total_interest_recovered_fixed = $row_loanrec_fixed['total_interest_recovered'] ?? 0;
$total_loanrec_fixed = $row_loanrec_fixed['total_recovered'] ?? 0;

// Select Loan Recoveries from Jamii LOANS
$sql_loanrec_jamii_fixed = "SELECT 
                SUM(ltrans_principal) AS total_principal_recovered,
                SUM(ltrans_interest) AS total_interest_recovered,
                SUM(ltrans_principal + ltrans_interest) AS total_recovered
                FROM ltrans
                JOIN loans ON ltrans.loan_id = loans.loan_id
                AND loans.loanstatus_id IN (2, 4, 5)
                AND loans.loan_interest = 0 ";

$query_loanrec_jamii_fixed = mysqli_query($db_link, $sql_loanrec_jamii_fixed);
checkSQL($db_link, $query_loanrec_jamii_fixed);

$row_loanrec_jamii_fixed = mysqli_fetch_assoc($query_loanrec_jamii_fixed);
$total_principal_recovered_jamii_fixed = $row_loanrec_jamii_fixed['total_principal_recovered'] ?? 0;
$total_interest_recovered_jamii_fixed = $row_loanrec_jamii_fixed['total_interest_recovered'] ?? 0;
$total_loanrec_jamii_fixed = $row_loanrec_jamii_fixed['total_recovered'] ?? 0;

// Select Saving Withdrawals from SAVINGS
$sql_savwithd = "SELECT * FROM savings WHERE sav_date BETWEEN $financial_start_date AND $financial_end_date AND savtype_id = 2";
$query_savwithd = mysqli_query($db_link, $sql_savwithd);
checkSQL($db_link, $query_savwithd);
$total_savwithd = 0;
while($row_savwithd = mysqli_fetch_assoc($query_savwithd)){
    $total_savwithd = $total_savwithd + $row_savwithd['sav_amount'];
}
$total_savwithd = $total_savwithd * (-1);

// Select Loans Out from LOANS
$sql_loanout = "SELECT * FROM loans WHERE loan_dateout BETWEEN $financial_start_date AND $financial_end_date";
$query_loanout = mysqli_query($db_link, $sql_loanout);
checkSQL($db_link, $query_loanout);
$total_loanout = 0;
while($row_loanout = mysqli_fetch_assoc($query_loanout)){
    $total_loanout = $total_loanout + $row_loanout['loan_principal'];
}

// Select Loans Out from LOANS ALL
$sql_loanout_fixed = "SELECT * FROM loans WHERE loanstatus_id IN (2,4,5) AND loan_interest > 0";
$query_loanout_fixed = mysqli_query($db_link, $sql_loanout_fixed);
checkSQL($db_link, $query_loanout_fixed);
$total_loanout_fixed = 0;
while($row_loanout_fixed = mysqli_fetch_assoc($query_loanout_fixed)){
    $total_loanout_fixed = $total_loanout_fixed + $row_loanout_fixed['loan_principal'];
}

// Select Loans Out from SOCIAL LOAN
$sql_loanout_saving = "SELECT * FROM loans WHERE loan_dateout BETWEEN $financial_start_date AND $financial_end_date AND loan_interest= 0 AND loanstatus_id IN (2, 5) ";
$query_loanout_saving = mysqli_query($db_link, $sql_loanout_saving);
checkSQL($db_link, $query_loanout_saving);
$total_loanout_saving = 0;
while($row_loanout_saving = mysqli_fetch_assoc($query_loanout_saving)){
    $total_loanout_saving = $total_loanout_saving + $row_loanout_saving['loan_principal'];
}

// Select Loans Out from SOCIAL LOAN
$sql_loanout_saving_fixed = "SELECT * FROM loans WHERE loan_interest= 0 AND loanstatus_id IN (2, 5) ";
$query_loanout_saving_fixed = mysqli_query($db_link, $sql_loanout_saving_fixed);
checkSQL($db_link, $query_loanout_saving_fixed);
$total_loanout_saving_fixed = 0;
while($row_loanout_saving_fixed = mysqli_fetch_assoc($query_loanout_saving_fixed)){
    $total_loanout_saving_fixed = $total_loanout_saving_fixed + $row_loanout_saving_fixed['loan_principal'];
}

// New Share Value to identified Customers 
$sql_payout = "SELECT customer.cust_name ,loans.cust_id FROM ltrans INNER JOIN loans ON ltrans.loan_id=loans.loan_id INNER JOIN customer ON loans.cust_id=customer.cust_id WHERE ltrans.ltrans_date BETWEEN $firstDay_loan AND $lastDay_loan GROUP BY loans.cust_id HAVING sum(ltrans_interest)>239999 UNION DISTINCT SELECT customer.cust_name,loans.cust_id FROM `loans`, customer WHERE loans.cust_id=customer.cust_id AND customer.cust_active=1 AND loans.loan_issued=1 AND loans.loan_interest>=10 AND loans.loan_date BETWEEN $firstDay_loan AND $lastDay_loan GROUP BY loans.cust_id HAVING SUM(loans.loan_principal)>2399999";
$query_payout = mysqli_query($db_link, $sql_payout);
checkSQL($db_link, $query_payout);

// Used to get total valid payouts
$sql_payouts = "SELECT customer.cust_name ,loans.cust_id FROM ltrans INNER JOIN loans ON ltrans.loan_id=loans.loan_id INNER JOIN customer ON loans.cust_id=customer.cust_id WHERE ltrans.ltrans_date BETWEEN $firstDay_loan AND $lastDay_loan GROUP BY loans.cust_id HAVING sum(ltrans_interest)>239999 UNION DISTINCT SELECT customer.cust_name,loans.cust_id FROM `loans`, customer WHERE loans.cust_id=customer.cust_id AND customer.cust_active=1 AND loans.loan_issued=1 AND loans.loan_interest>=10 AND loans.loan_date BETWEEN $firstDay_loan AND $lastDay_loan GROUP BY loans.cust_id HAVING SUM(loans.loan_principal)>2399999";
$query_payouts = mysqli_query($db_link, $sql_payouts);
checkSQL($db_link, $query_payouts);

// Used to get total invalid payouts
$sql_payouts_other = "SELECT customer.cust_name, customer.cust_id
FROM customer where customer.cust_id NOT IN (SELECT loans.cust_id FROM ltrans INNER JOIN loans ON ltrans.loan_id=loans.loan_id INNER JOIN customer ON loans.cust_id=customer.cust_id WHERE ltrans.ltrans_date BETWEEN $firstDay_loan AND $lastDay_loan GROUP BY loans.cust_id HAVING sum(ltrans_interest)>239999 UNION DISTINCT SELECT loans.cust_id FROM `loans`, customer WHERE loans.cust_id=customer.cust_id AND customer.cust_active=1 AND loans.loan_issued=1 AND loans.loan_interest>=10 AND loans.loan_date BETWEEN $firstDay_loan AND $lastDay_loan GROUP BY loans.cust_id HAVING SUM(loans.loan_principal)>2399999)AND customer.cust_active=1";
$query_payouts_other = mysqli_query($db_link, $sql_payouts_other);
checkSQL($db_link, $query_payouts_other);

// Used to get total invalid payouts
$sql_payouts_others = "SELECT customer.cust_name, customer.cust_id
FROM customer where customer.cust_id NOT IN (SELECT loans.cust_id FROM ltrans INNER JOIN loans ON ltrans.loan_id=loans.loan_id INNER JOIN customer ON loans.cust_id=customer.cust_id WHERE ltrans.ltrans_date BETWEEN $firstDay_loan AND $lastDay_loan GROUP BY loans.cust_id HAVING sum(ltrans_interest)>239999 UNION DISTINCT SELECT loans.cust_id FROM `loans`, customer WHERE loans.cust_id=customer.cust_id AND customer.cust_active=1 AND loans.loan_issued=1 AND loans.loan_interest>=10 AND loans.loan_date BETWEEN $firstDay_loan AND $lastDay_loan GROUP BY loans.cust_id HAVING SUM(loans.loan_principal)>2399999)AND customer.cust_active=1";
$query_payouts_others = mysqli_query($db_link, $sql_payouts_others);
checkSQL($db_link, $query_payouts_others);

// Select Loan Recoveries from LTRANS
$sql_loanrec = "SELECT * FROM ltrans, loans WHERE ltrans.loan_id = loans.loan_id AND ltrans_date BETWEEN $financial_start_date AND $financial_end_date ORDER BY ltrans_date, loans.cust_id";
$query_loanrec = mysqli_query($db_link, $sql_loanrec);
checkSQL($db_link, $query_loanrec);

// Select Loans Out from LOANS
$sql_loanout = "SELECT * FROM loans, customer WHERE loans.cust_id = customer.cust_id AND loans.loan_dateout BETWEEN $financial_start_date AND $financial_end_date ORDER BY loan_dateout, loans.cust_id";
$query_loanout = mysqli_query($db_link, $sql_loanout);
checkSQL($db_link, $query_loanout);

$total_loandue = 0;
while($row_loandue = mysqli_fetch_assoc($query_loandue)){
    $total_loandue = $total_loandue + $row_loandue['ltrans_principaldue'] + $row_loandue['ltrans_interestdue'];
}

$total_loanrec = 0;
while($row_loanrec = mysqli_fetch_assoc($query_loanrec)){
    $total_loanrec = $total_loanrec + $row_loanrec['ltrans_principal'] + $row_loanrec['ltrans_interest'];
}

$testmay =0;
$total_loanout = 0;
while($row_loanout = mysqli_fetch_assoc($query_loanout)){
    $testmay =$row_loanout['loan_id'];

    $sql ="SELECT (SUM(ltrans_principal) + SUM(ltrans_interest)) AS ipaid FROM ltrans WHERE loan_id =$testmay AND ltrans_date BETWEEN $financial_start_date AND $financial_end_date ";
    $result = mysqli_query($db_link, $sql);
    $row = mysqli_fetch_assoc($result);

    $total_loanout = $total_loanout + $row_loanout['loan_principal'];
}

// Select Not cleared Loans from LTRANS
$sql_loancleared = "SELECT * FROM ltrans, loans, loanstatus, customer WHERE ltrans.loan_id = loans.loan_id AND loans.loanstatus_id = loanstatus.loanstatus_id AND loans.cust_id = customer.cust_id AND ltrans_due BETWEEN $financial_start_date AND $financial_end_date AND loans.loanstatus_id IN (2) GROUP BY loans.loan_id ORDER BY loans.loan_interest, loans.loan_repaytotal, ltrans_due";
$query_loancleared = mysqli_query($db_link, $sql_loancleared);
checkSQL($db_link, $query_loancleared);

$testmaycleared =0;
$total_loancleared = 0;
while($row_loancleared = mysqli_fetch_assoc($query_loancleared)){
    $testmaycleared =$row_loancleared['loan_id'];

    $sqlcleared ="SELECT (SUM(ltrans_principal) + SUM(ltrans_interest)) AS ipaid, (SUM(ltrans_principaldue)+ SUM(ltrans_interestdue)) AS principle FROM ltrans WHERE loan_id =$testmaycleared AND ltrans_date BETWEEN $financial_start_date AND $financial_end_date ";
    $resultcleared = mysqli_query($db_link, $sqlcleared);
    $rowcleared = mysqli_fetch_assoc($resultcleared);

    $total_loancleared = $total_loancleared + $rowcleared['ipaid']-$row_loancleared['loan_repaytotal'];
}

// Calculate totals for payouts
$total_vshares_payouts=0;
$total_shares_payouts =0 ;
$cust_id_payouts =0;

while($row_payouts = mysqli_fetch_assoc($query_payouts)){
    $cust_id_payouts =$row_payouts['cust_id'];

    $sql_payouts_shares ="SELECT SUM(share_amount) AS tshares, SUM(share_value) AS vshares FROM shares WHERE cust_id = $cust_id_payouts AND share_date BETWEEN $financial_start_date AND $financial_end_date ";
    $result_payouts_shares = mysqli_query($db_link, $sql_payouts_shares);
    $row_payouts_shares = mysqli_fetch_assoc($result_payouts_shares);

    $total_shares_payouts = $total_shares_payouts + $row_payouts_shares['tshares'];
    $total_vshares_payouts = $total_vshares_payouts + $row_payouts_shares['vshares'];
}

$total_social_payout=0;
$total_figure_payout=0;
$total_loans_payout=0;
$total_share_dividends= 0;
$total_vshares_payout= 0;
$total_nvshares_payout =0 ;
$total_shares_payout =0 ;
$cust_id_payout =0;
$total_interest1 = 0;

while($row_payout = mysqli_fetch_assoc($query_payout)){
    $cust_id_payout =$row_payout['cust_id'];

    $sql_payout_shares ="SELECT loans.cust_id,(SELECT SUM(sav_amount) FROM savings WHERE savings.cust_id=loans.cust_id AND savings.sav_date BETWEEN $financial_start_date AND $financial_end_date) AS savbal_balance,(SELECT cust_name FROM customer WHERE customer.cust_id=loans.cust_id) AS cust_name, (SELECT SUM(shares.share_amount ) FROM shares WHERE shares.cust_id=loans.cust_id AND shares.share_date BETWEEN $financial_start_date AND $financial_end_date) AS tshares, (SELECT SUM(shares.share_value) FROM shares WHERE shares.cust_id=loans.cust_id AND shares.share_date BETWEEN $financial_start_date AND $financial_end_date) AS vshares ,(SUM(ltrans.ltrans_principaldue)+SUM(ltrans.ltrans_interestdue)) AS loan, (SUM(ltrans.ltrans_principal)+SUM(ltrans.ltrans_interest)) AS ipaid FROM ltrans, loans WHERE loans.loan_id=ltrans.loan_id AND loans.loan_date BETWEEN $financial_start_date AND $financial_end_date AND loans.cust_id=$cust_id_payout GROUP BY loans.cust_id ";
    $result_payout_shares = mysqli_query($db_link, $sql_payout_shares);
    $row_payout_shares = mysqli_fetch_assoc($result_payout_shares);
    
    $sql_interest_payout1 = "SELECT customer.cust_name ,loans.cust_id, sum(ltrans_principaldue), sum(ltrans_interest) As total_intrest FROM ltrans INNER JOIN loans ON ltrans.loan_id=loans.loan_id INNER JOIN customer ON loans.cust_id=customer.cust_id WHERE ltrans.ltrans_date BETWEEN $financial_start_date AND $financial_end_date AND loans.cust_id=$cust_id_payout GROUP  BY loans.cust_id ";
    $query_payout_interest1 = mysqli_query($db_link, $sql_interest_payout1);
    $row_payout_interest1 = mysqli_fetch_assoc($query_payout_interest1);

    $total_shares_payout = $total_shares_payout + $row_payout_shares['tshares'];
    $total_vshares_payout = $total_vshares_payout + $row_payout_shares['vshares'];
    $total_nvshares_payout = $total_nvshares_payout + ($row_payout_shares['tshares']*(($total_vshares_payouts + $total_incomes-$total_expendit_dividends_fixed)/$total_shares_payouts));
    $total_share_dividends=$total_share_dividends + (($row_payout_shares['tshares']*(($total_vshares_payouts + $total_incomes-$total_expendit_dividends_fixed)/$total_shares_payouts)) -$row_payout_shares['vshares']);
    $total_loans_payout= $total_loans_payout + ($row_payout_shares['ipaid']-$row_payout_shares['loan']);
    $total_figure_payout= $total_figure_payout + (($row_payout_shares['tshares']*(($total_vshares_payouts + $total_incomes)/$total_shares_payouts))+$row_payout_shares['ipaid']-$row_payout_shares['loan']);
    $total_interest1 = $total_interest1 + $row_payout_interest1['total_intrest'];
}

// Calculate totals for other payouts
$total_vshares_payouts_other=0;
$total_shares_payouts_other =0 ;
$cust_id_payouts_other =0;

while($row_payouts_other = mysqli_fetch_assoc($query_payouts_others)){
    $cust_id_payouts_other =$row_payouts_other['cust_id'];

    $sql_payouts_shares_other ="SELECT SUM(share_amount) AS tshares, SUM(share_value) AS vshares FROM shares WHERE cust_id = $cust_id_payouts_other AND share_date BETWEEN $financial_start_date AND $financial_end_date ";
    $result_payouts_shares_other = mysqli_query($db_link, $sql_payouts_shares_other);
    $row_payouts_shares_other = mysqli_fetch_assoc($result_payouts_shares_other);

    $total_shares_payouts_other = $total_shares_payouts_other + $row_payouts_shares_other['tshares'];
    $total_vshares_payouts_other = $total_vshares_payouts_other + $row_payouts_shares_other['vshares'];
}

$total_social_payout_other=0;
$total_figure_payout_other=0;
$total_loan_payout_other=0;
$total_dividend_payout_other=0;
$total_vshares_payout_other= 0;
$total_nvshares_payout_other =0 ;
$total_shares_payout_other =0 ;
$cust_id_payout_other =0;
$total_interest2 = 0;

while($row_payout_other = mysqli_fetch_assoc($query_payouts_other)){
    $cust_id_payout_other =$row_payout_other['cust_id'];

    $sql_payout_shares_other ="SELECT loans.cust_id,(SELECT SUM(sav_amount) FROM savings WHERE savings.cust_id=loans.cust_id AND savings.sav_date BETWEEN $financial_start_date AND $financial_end_date) AS savbal_balance,(SELECT cust_name FROM customer WHERE customer.cust_id=loans.cust_id) AS cust_name, (SELECT SUM(shares.share_amount ) FROM shares WHERE shares.cust_id=loans.cust_id AND shares.share_date BETWEEN $financial_start_date AND $financial_end_date) AS tshares, (SELECT SUM(shares.share_value) FROM shares WHERE shares.cust_id=loans.cust_id AND shares.share_date BETWEEN $financial_start_date AND $financial_end_date) AS vshares ,(SUM(ltrans.ltrans_principaldue)+SUM(ltrans.ltrans_interestdue)) AS loan, (SUM(ltrans.ltrans_principal)+SUM(ltrans.ltrans_interest)) AS ipaid FROM ltrans, loans WHERE loans.loan_id=ltrans.loan_id AND loans.cust_id=$cust_id_payout_other  GROUP BY loans.cust_id ";
    $result_payout_shares_other = mysqli_query($db_link, $sql_payout_shares_other);
    $row_payout_shares_other = mysqli_fetch_assoc($result_payout_shares_other);
    
    $sql_interest_payout2 = "SELECT customer.cust_name ,loans.cust_id, sum(ltrans_principaldue), sum(ltrans_interest) As total_intrest FROM ltrans INNER JOIN loans ON ltrans.loan_id=loans.loan_id INNER JOIN customer ON loans.cust_id=customer.cust_id WHERE ltrans.ltrans_date BETWEEN $financial_start_date AND $financial_end_date AND loans.cust_id=$cust_id_payout_other GROUP  BY loans.cust_id ";
    $query_payout_interest2 = mysqli_query($db_link, $sql_interest_payout2);
    $row_payout_interest2 = mysqli_fetch_assoc($query_payout_interest2);

    $total_shares_payout_other = $total_shares_payout_other + $row_payout_shares_other['tshares'];
    $total_vshares_payout_other = $total_vshares_payout_other + $row_payout_shares_other['vshares'];
    $total_dividend_payout_other=$total_dividend_payout_other +($row_payout_shares_other['vshares']-$row_payout_shares_other['vshares']);
    $total_loan_payout_other=$total_loan_payout_other + ($row_payout_shares_other['ipaid']-$row_payout_shares_other['loan']);
    $total_figure_payout_other=$total_figure_payout_other +($row_payout_shares_other['vshares']+$row_payout_shares_other['ipaid']-$row_payout_shares_other['loan']);
    $total_interest2 = $total_interest2 + $row_payout_interest2['total_intrest'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Financial Dashboard</title>
    <style>
        :root {
            --primary-color: #3498db;
            --secondary-color: #2ecc71;
            --danger-color: #e74c3c;
            --warning-color: #f39c12;
            --info-color: #9b59b6;
            --dark-color: #34495e;
            --light-color: #ecf0f1;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f7fa;
            margin: 0;
            padding: 10px;
            color: #333;
            font-size: 14px;
        }
        
        .dashboard-header {
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
        }
        
        .dashboard-header h1 {
            color: #2c3e50;
            margin-bottom: 10px;
            font-size: 1.5rem;
        }
        
        .widgets-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .widget {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            padding: 15px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .widget:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .widget-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .widget-title {
            font-size: 14px;
            font-weight: 600;
            color: #7f8c8d;
            margin: 0;
        }
        
        .widget-icon {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 14px;
        }
        
        .widget-value {
            font-size: 20px;
            font-weight: 700;
            margin: 8px 0;
            word-break: break-all;
        }
        
        .widget-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 12px;
            color: #95a5a6;
        }
        
        .widget-trend {
            display: flex;
            align-items: center;
        }
        
        .trend-up {
            color: var(--secondary-color);
        }
        
        .trend-down {
            color: var(--danger-color);
        }
        
        /* Specific widget colors */
        .widget-share {
            border-left: 4px solid var(--primary-color);
        }
        
        .widget-share .widget-icon {
            background-color: var(--primary-color);
        }
        
        .widget-jamii {
            border-left: 4px solid var(--secondary-color);
        }
        
        .widget-jamii .widget-icon {
            background-color: var(--secondary-color);
        }
        
        .widget-share-value {
            border-left: 4px solid var(--info-color);
        }
        
        .widget-share-value .widget-icon {
            background-color: var(--info-color);
        }
        
        .widget-account {
            border-left: 4px solid var(--warning-color);
        }
        
        .widget-account .widget-icon {
            background-color: var(--warning-color);
        }
        
        .widget-loans {
            border-left: 4px solid var(--dark-color);
        }
        
        .widget-loans .widget-icon {
            background-color: var(--dark-color);
        }
        
        .widget-repayments {
            border-left: 4px solid #1abc9c;
        }
        
        .widget-repayments .widget-icon {
            background-color: #1abc9c;
        }
        
        .widget-expenses {
            border-left: 4px solid var(--danger-color);
        }
        
        .widget-expenses .widget-icon {
            background-color: var(--danger-color);
        }
        
        /* Monthly report styles */
        .monthly-report {
            margin-top: 30px;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        
        .monthly-report h1 {
            text-align: center;
            color: #2c3e50;
            font-size: 1.3rem;
            margin-bottom: 15px;
            padding: 0 10px;
        }
        
        .filter-container {
            text-align: center;
            margin-bottom: 15px;
            padding: 0 10px;
        }
        
        .filter-container label {
            display: inline-block;
            margin: 5px 0;
        }
        
        .filter-container select, 
        .filter-container input[type="submit"] {
            padding: 8px 12px;
            font-size: 14px;
            margin: 5px;
            border: 1px solid #ddd;
            border-radius: 4px;
            width: 100%;
            max-width: 200px;
        }
        
        .filter-container input[type="submit"] {
            background-color: var(--primary-color);
            color: white;
            border: none;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .filter-container input[type="submit"]:hover {
            background-color: #2980b9;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            background-color: #fff;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.05);
            min-width: 800px; /* Allows horizontal scrolling on small screens */
        }
        
        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: center;
            font-size: 11px;
        }
        
        th {
            background-color: #4CAF50;
            color: white;
            font-weight: bold;
            position: sticky;
            top: 0;
        }
        
        .total-row {
            font-weight: bold;
            background-color: #e0e0e0;
        }
        
        .group-header {
            font-weight: bold;
            background-color: #d0d0d0;
            text-align: left;
        }
        
        .group-total {
            font-weight: bold;
            background-color: #f0f0f0;
        }
        
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        
        tr:hover {
            background-color: #e9e9e9;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            body {
                padding: 5px;
                font-size: 13px;
            }
            
            .dashboard-header h1 {
                font-size: 1.3rem;
            }
            
            .widgets-container {
                grid-template-columns: 1fr;
                gap: 10px;
            }
            
            .widget {
                padding: 12px;
            }
            
            .widget-value {
                font-size: 18px;
            }
            
            .filter-container select, 
            .filter-container input[type="submit"] {
                width: 45%;
                max-width: none;
            }
            
            th, td {
                padding: 4px;
                font-size: 10px;
            }
        }
        
        @media (max-width: 480px) {
            .dashboard-header h1 {
                font-size: 1.2rem;
            }
            
            .widget-title {
                font-size: 13px;
            }
            
            .widget-value {
                font-size: 16px;
            }
            
            .filter-container select, 
            .filter-container input[type="submit"] {
                width: 90%;
                display: block;
                margin: 5px auto;
            }
            
            .monthly-report h1 {
                font-size: 1.1rem;
            }
        }
        
        /* Print styles */
        @media print {
            body {
                background-color: white;
                padding: 0;
                font-size: 10pt;
            }
            
            .dashboard-header, .widgets-container {
                display: none;
            }
            
            .monthly-report {
                margin-top: 0;
            }
            
            table {
                width: 100%;
                min-width: 0;
                box-shadow: none;
            }
            
            th, td {
                padding: 3px;
                font-size: 8pt;
            }
        }
        


.column-headers {
    background-color: #f5f5f5 !important;
    position: sticky;
    top: 31px; /* Below the group header */
    z-index: 9; /* Below group header but above regular rows */
}

.column-headers th {
    background-color: #f5f5f5 !important;
    color: #333 !important;
    font-size: 10px;
    padding: 4px;
    text-align: center;
    font-weight: bold;
    border-bottom: 2px solid #ddd;
}

.group-header {
    position: sticky;
    top: 0;
    z-index: 10;
    background-color: #d0d0d0 !important;
}

@media (max-width: 768px) {
    .column-headers th {
        font-size: 9px;
        padding: 3px;
    }
    
    .column-headers {
        top: 26px; /* Adjusted for smaller group header on mobile */
    }
}
    </style>
</head>
<body>
    <div class="dashboard-header">
        <h1><?php echo $companyName; ?> Financial Dashboard</h1>
        <p>Key metrics and monthly report for <?php echo date('F, Y', $firstDay); ?></p>
    
        <!-- Filter Form -->
        <div class="filter-container">
            <form method="POST" action="">
                <label for="month">Month:</label>
                <select name="month" id="month">
                    <?php for ($i = 1; $i <= 12; $i++): ?>
                        <option value="<?php echo $i; ?>" <?php echo $i == $selected_month ? 'selected' : ''; ?>>
                            <?php echo date('F', mktime(0, 0, 0, $i, 10)); ?>
                        </option>
                    <?php endfor; ?>
                </select>

                <label for="year">Year:</label>
                <select name="year" id="year">
                    <?php for ($i = date('Y') - 5; $i <= date('Y') + 5; $i++): ?>
                        <option value="<?php echo $i; ?>" <?php echo $i == $selected_year ? 'selected' : ''; ?>>
                            <?php echo $i; ?>
                        </option>
                    <?php endfor; ?>
                </select>

                <input type="submit" value="Filter">
            </form>
        </div>
    </div>
    
    <div class="widgets-container">
        <!-- Total Account Balance Widget -->
        <div class="widget widget-account">
            <div class="widget-header">
                <h3 class="widget-title">Total Account Balance</h3>
                <div class="widget-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="15" height="" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 12a9 9 0 0 0-9-9 9 9 0 0 0-9 9 9 9 0 0 0 9 9 9 9 0 0 0 9-9z"></path>
                        <circle cx="12" cy="12" r="3"></circle>
                    </svg>
                </div>
            </div>
            <div class="widget-value"><?php echo number_format($total_savdep_fixed-$total_loanout_saving_fixed-$total_expendit_others_fixed+$total_loanrec_jamii_fixed+$total_shares_value + $total_incomes_others_fixed-$total_expendit_dividends_fixed+$total_loanrec_fixed-$total_loanout_fixed); ?> <?php echo $_SESSION['set_cur']; ?></div>
            <div class="widget-footer">
                <span>Share Fund: <?php echo number_format($total_shares_value); ?></span>
                <div class="widget-trend trend-up">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                        <polyline points="17 6 23 6 23 12"></polyline>
                    </svg>
                    <?php echo number_format(($total_shares_value_fixed/$total_shares_value)*100, 2); ?>%
                </div>
            </div>
        </div>
        
        <!-- Share Balance Widget -->
        <div class="widget widget-share">
            <div class="widget-header">
                <h3 class="widget-title">Share A/C Balance</h3>
                <div class="widget-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"></circle>
                        <line x1="8" y1="12" x2="16" y2="12"></line>
                        <line x1="12" y1="8" x2="12" y2="16"></line>
                    </svg>
                </div>
            </div>
            <div class="widget-value"><?php 
            echo number_format($total_shares_value + $total_incomes_others_fixed-$total_expendit_dividends_fixed+$total_loanrec_fixed-$total_loanout_fixed); ?> <?php echo $_SESSION['set_cur']; ?></div>
            <div class="widget-footer">
                <span>Total shares: <?php echo number_format( $total_shares_fixed); ?></span>
                <div class="widget-trend trend-up">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                        <polyline points="17 6 23 6 23 12"></polyline>
                    </svg>
                    <?php echo number_format($total_shares/$total_shares_fixed, 2); ?> 
                </div>
            </div>
        </div>
        
        <!-- Jamii Balance Widget -->
        <div class="widget widget-jamii">
            <div class="widget-header">
                <h3 class="widget-title">Jamii A/C Balance</h3>
                <div class="widget-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                        <circle cx="9" cy="7" r="4"></circle>
                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                        <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                    </svg>
                </div>
            </div>
            <div class="widget-value"><?php echo number_format($total_savdep_fixed-$total_loanout_saving_fixed-$total_expendit_others_fixed+$total_loanrec_jamii_fixed
); ?> <?php echo $_SESSION['set_cur']; ?></div>
            <div class="widget-footer">
                <span>Total contributions: <?php echo number_format($total_savdep); ?></span>
                <div class="widget-trend trend-up">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                        <polyline points="17 6 23 6 23 12"></polyline>
                    </svg>
                    <?php echo number_format(($total_savdep/$total_savdep_fixed)*100, 2); ?>%
                </div>
            </div>
        </div>
        
        <!-- Unit Share Value Widget -->
        <div class="widget widget-share-value">
            <div class="widget-header">
                <h3 class="widget-title">Unit Share Value (FY)</h3>
                <div class="widget-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="1" x2="12" y2="23"></line>
                        <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                    </svg>
                </div>
            </div>
            <div class="widget-value"><?php echo number_format(( $total_shares_value + $total_incomes_fixed-$total_expendit_dividends_fixed)/$total_shares_fixed); ?> <?php echo $_SESSION['set_cur']; ?></div>
            <div class="widget-footer">
                <span>Initial value: <?php echo number_format($default_share); ?></span>
                <div class="widget-trend trend-up">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                        <polyline points="17 6 23 6 23 12"></polyline>
                    </svg>
                    <?php echo number_format((((( $total_shares_value + $total_incomes_fixed-$total_expendit_dividends_fixed)/$total_shares_fixed)-$default_share)/$default_share)*100, 2); ?>
                </div>
            </div>
        </div>
        
        <!-- Loans Provided Widget -->
        <div class="widget widget-loans">
            <div class="widget-header">
                <h3 class="widget-title">Loans Provided (FY)</h3>
                <div class="widget-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M12 1a3 3 0 0 0-3 3v8a3 3 0 0 0 6 0V4a3 3 0 0 0-3-3z"></path>
                        <path d="M19 10v2a7 7 0 0 1-14 0v-2"></path>
                        <line x1="12" y1="19" x2="12" y2="23"></line>
                        <line x1="8" y1="23" x2="16" y2="23"></line>
                    </svg>
                </div>
            </div>
            <div class="widget-value"><?php echo number_format($total_loanout); ?> <?php echo $_SESSION['set_cur']; ?></div>
            <div class="widget-footer">
                <span>Social loans: <?php echo number_format($total_loanout_saving); ?></span>
                <div class="widget-trend trend-up">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                        <polyline points="17 6 23 6 23 12"></polyline>
                    </svg>
                    <?php echo number_format(($total_loanout - $total_loanout_saving) / $total_loanout * 100, 2); ?>%
                </div>
            </div>
        </div>
        
        <!-- Loan Repayments Widget -->
        <div class="widget widget-repayments">
            <div class="widget-header">
                <h3 class="widget-title">Loan Repayments (FY)</h3>
                <div class="widget-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                        <polyline points="14 2 14 8 20 8"></polyline>
                        <line x1="16" y1="13" x2="8" y2="13"></line>
                        <line x1="16" y1="17" x2="8" y2="17"></line>
                        <polyline points="10 9 9 9 8 9"></polyline>
                    </svg>
                </div>
            </div>
            <div class="widget-value"><?php echo number_format($total_loanrec); ?> <?php echo $_SESSION['set_cur']; ?></div>
            <div class="widget-footer">
                <span>Interest: <?php echo number_format($total_interest1 + $total_interest2); ?></span>
                <div class="widget-trend trend-up">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                        <polyline points="17 6 23 6 23 12"></polyline>
                    </svg>
                    <?php echo number_format(($total_loanrec / $total_loanout * 100), 2); ?>%
                </div>
            </div>
        </div>
        
        <!-- Expenses Widget -->
        <div class="widget widget-expenses">
            <div class="widget-header">
                <h3 class="widget-title">Expenses (FY)</h3>
                <div class="widget-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M12 2v4m0 12v4M4.93 4.93l2.83 2.83m8.48 8.48l2.83 2.83M2 12h4m12 0h4M4.93 19.07l2.83-2.83m8.48-8.48l2.83-2.83"></path>
                    </svg>
                </div>
            </div>
            <div class="widget-value"><?php echo number_format($total_expendit_others + $total_expendit_dividends); ?> <?php echo $_SESSION['set_cur']; ?></div>
            <div class="widget-footer">
                <span>Dividends: <?php echo number_format( $total_expendit_dividends); ?></span>
                <div class="widget-trend trend-down">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="23 18 13.5 8.5 8.5 13.5 1 6"></polyline>
                        <polyline points="17 18 23 18 23 12"></polyline>
                    </svg>
                    <?php echo number_format(($total_expendit_dividends/ $total_expendit_dividends_fixed) * 100, 2); ?>%
                </div>
            </div>
        </div>
        
        <!-- Total Income Widget -->
        <div class="widget widget-repayments">
            <div class="widget-header">
                <h3 class="widget-title">Total Income (FY)</h3>
                <div class="widget-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                        <polyline points="14 2 14 8 20 8"></polyline>
                        <line x1="16" y1="13" x2="8" y2="13"></line>
                        <line x1="16" y1="17" x2="8" y2="17"></line>
                        <polyline points="10 9 9 9 8 9"></polyline>
                    </svg>
                </div>
            </div>
            <div class="widget-value"><?php echo number_format($total_incomes); ?> <?php echo $_SESSION['set_cur']; ?></div>
            <div class="widget-footer">
                <span>Interest: <?php echo number_format($total_incomes-$total_incomes_others); ?></span>
                <div class="widget-trend trend-up">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                        <polyline points="17 6 23 6 23 12"></polyline>
                    </svg>
                    <?php echo number_format(($total_incomes / $total_incomes_fixed * 100), 2); ?>%
                </div>
            </div>
        </div>
    </div>
    
<div class="monthly-report">
    <h1><?php echo $companyName; ?> Collection Chart for <?php echo date('F, Y', $firstDay); ?></h1>

    <table>
        <thead>
            <tr>
                <th>Name</th>
                <th>Total Share</th>
                <th>Total Share Value</th>
                <th>Jamii Expected</th>
                <th>Loan Monthly</th>
                <th>Loan Paid</th>
                <th>Loan Remaining</th>
                <th>Remaining Balance</th>
                <th>Shares Current</th>
                <th>Jamii Current</th>
                <th>PVE (%)</th>
                <th>Dividends</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $current_group = '';
            $group_total_share = 0;
            $group_total_share_value = 0;
            $group_total_shares_current_month = 0;
            $group_total_jamii_current_month = 0;
            $group_total_jamii_expected_monthly_instalment = 0;
            $group_total_monthly_installment = 0;
            $group_total_normal_paid_monthly_instalment = 0;
            $group_total_normal_remaining_monthly_instalment = 0;
            $group_total_remaining_loan_balance = 0;
            $group_total_pve = 0;
            $group_total_dividends = 0;
            $group_count = 0;
            $group_member_count = 0;

            // Store all rows to count group members first
            $all_rows = [];
            while ($row = mysqli_fetch_assoc($query)) {
                $all_rows[] = $row;
            }

            // Reset pointer
            mysqli_data_seek($query, 0);

            foreach ($all_rows as $row):
                if ($current_group != $row['cust_group']) {
                    // Count members in this group
                    $group_member_count = 0;
                    foreach ($all_rows as $r) {
                        if ($r['cust_group'] == $row['cust_group']) {
                            $group_member_count++;
                        }
                    }

                    if ($current_group != '') {
                        echo '<tr class="group-total">
                                <td>Group Total</td>
                                <td>' . number_format($group_total_share, 2) . '</td>
                                <td>' . number_format($group_total_share_value, 2) . '</td>
                                <td>' . number_format($group_total_jamii_expected_monthly_instalment, 2) . '</td>
                                <td>' . number_format($group_total_monthly_installment, 2) . '</td>
                                <td>' . number_format($group_total_normal_paid_monthly_instalment, 2) . '</td>
                                <td>' . number_format($group_total_normal_remaining_monthly_instalment, 2) . '</td>
                                <td>' . number_format($group_total_remaining_loan_balance, 2) . '</td>
                                <td>' . number_format($group_total_shares_current_month, 2) . '</td>
                                <td>' . number_format($group_total_jamii_current_month, 2) . '</td>
                                <td>' . number_format($group_total_pve / $group_count, 2) . '</td>
                                <td>' . number_format($group_total_dividends, 2) . '</td>
                              </tr>';
                    }

                    // Reset group totals
                    $group_total_share = 0;
                    $group_total_share_value = 0;
                    $group_total_shares_current_month = 0;
                    $group_total_jamii_current_month = 0;
                    $group_total_jamii_expected_monthly_instalment = 0;
                    $group_total_monthly_installment = 0;
                    $group_total_normal_paid_monthly_instalment = 0;
                    $group_total_normal_remaining_monthly_instalment = 0;
                    $group_total_remaining_loan_balance = 0;
                    $group_total_pve = 0;
                    $group_total_dividends = 0;
                    $group_count = 0;

                    $current_group = $row['cust_group'];
                    echo '<tr class="group-header">
                            <td colspan="12">Group: ' . $current_group . '</td>
                          </tr>';

                    // Add column headers if group has more than 5 members (except for group header)
                    if ($group_member_count > 4) {
                        echo '<tr class="column-headers">
                                 <th>Name</th>
                <th>Total Share</th>
                <th>Total Share Value</th>
                <th>Jamii Expected</th>
                <th>Loan Monthly</th>
                <th>Loan Paid</th>
                <th>Loan Remaining</th>
                <th>Remaining Balance</th>
                <th>Shares Current</th>
                <th>Jamii Current</th>
                <th>PVE (%)</th>
                <th>Dividends</th>
                              </tr>';
                    }
                }

                $normal_remaining_monthly_instalment = $row['monthly_installment'] - $row['normal_paid_monthly_instalment'];
            ?>
                <tr>
                    <td><?php echo $row['cust_name']; ?></td>
                    <td><?php echo number_format($row['total_share'], 2); ?></td>
                    <td><?php echo number_format($row['total_share_value'], 2); ?></td>
                    <td><?php echo number_format($row['jamii_expected_monthly_instalment'], 2); ?></td>
                    <td><?php echo number_format($row['monthly_installment']-$row['jamii_expected_monthly_instalment'], 2); ?></td>
                    <td><?php echo number_format($row['normal_paid_monthly_instalment'], 2); ?></td>
                    <td><?php echo number_format($normal_remaining_monthly_instalment-$row['jamii_expected_monthly_instalment'], 2); ?></td>
                    <td><?php echo number_format($row['remaining_loan_balance']-$row['normal_paid_monthly_instalment'], 2); ?></td>
                    <td><?php echo number_format($row['shares_current_month'], 2); ?></td>
                    <td><?php echo number_format($row['jamii_current_month'], 2); ?></td>
                    <td><?php echo number_format($row['pve_percentage'], 2); ?></td>
                    <td><?php echo number_format($row['dividends'], 2); ?></td>
                </tr>
                <?php
                // Update group totals
                $group_total_share += $row['total_share'];
                $group_total_share_value += $row['total_share_value'];
                $group_total_shares_current_month += $row['shares_current_month'];
                $group_total_jamii_current_month += $row['jamii_current_month'];
                $group_total_jamii_expected_monthly_instalment += $row['jamii_expected_monthly_instalment'];
                $group_total_monthly_installment += $row['monthly_installment']-$row['jamii_expected_monthly_instalment'];
                $group_total_normal_paid_monthly_instalment += $row['normal_paid_monthly_instalment'];
                $group_total_normal_remaining_monthly_instalment += $normal_remaining_monthly_instalment;
                $group_total_remaining_loan_balance += $row['remaining_loan_balance']-$row['normal_paid_monthly_instalment'];
                $group_total_pve += $row['pve_percentage'];
                $group_total_dividends += $row['dividends'];
                $group_count++;

                // Update grand totals
                $grand_total_share += $row['total_share'];
                $grand_total_share_value += $row['total_share_value'];
                $grand_total_shares_current_month += $row['shares_current_month'];
                $grand_total_jamii_current_month += $row['jamii_current_month'];
                $grand_total_jamii_expected_monthly_instalment += $row['jamii_expected_monthly_instalment'];
                $grand_total_monthly_installment += $row['monthly_installment'];
                $grand_total_normal_paid_monthly_instalment += $row['normal_paid_monthly_instalment'];
                $grand_total_normal_remaining_monthly_instalment += $normal_remaining_monthly_instalment;
                $grand_total_remaining_loan_balance += $row['remaining_loan_balance'];
                $grand_total_pve += $row['pve_percentage'];
                $grand_total_dividends += $row['dividends'];
                $grand_count++;
                ?>
            <?php endforeach; ?>
            
            <?php if ($current_group != ''): ?>
                <tr class="group-total">
                    <td>Group Total</td>
                    <td><?php echo number_format($group_total_share, 2); ?></td>
                    <td><?php echo number_format($group_total_share_value, 2); ?></td>
                    <td><?php echo number_format($group_total_jamii_expected_monthly_instalment, 2); ?></td>
                    <td><?php echo number_format($group_total_monthly_installment, 2); ?></td>
                    <td><?php echo number_format($group_total_normal_paid_monthly_instalment, 2); ?></td>
                    <td><?php echo number_format($group_total_normal_remaining_monthly_instalment, 2); ?></td>
                    <td><?php echo number_format($group_total_remaining_loan_balance, 2); ?></td>
                    <td><?php echo number_format($group_total_shares_current_month, 2); ?></td>
                    <td><?php echo number_format($group_total_jamii_current_month, 2); ?></td>
                    <td><?php echo number_format($group_total_pve / $group_count, 2); ?></td>
                    <td><?php echo number_format($group_total_dividends, 2); ?></td>
                </tr>
            <?php endif; ?>
            
            <tr class="total-row">
                <td>Grand Total</td>
                <td><?php echo number_format($grand_total_share, 2); ?></td>
                <td><?php echo number_format($grand_total_share_value, 2); ?></td>
                <td><?php echo number_format($grand_total_jamii_expected_monthly_instalment, 2); ?></td>
                <td><?php echo number_format($grand_total_monthly_installment, 2); ?></td>
                <td><?php echo number_format($grand_total_normal_paid_monthly_instalment, 2); ?></td>
                <td><?php echo number_format($grand_total_normal_remaining_monthly_instalment, 2); ?></td>
                <td><?php echo number_format($grand_total_remaining_loan_balance, 2); ?></td>
                <td><?php echo number_format($grand_total_shares_current_month, 2); ?></td>
                <td><?php echo number_format($grand_total_jamii_current_month, 2); ?></td>
                <td><?php echo number_format($grand_total_pve / $grand_count, 2); ?></td>
                <td><?php echo number_format($grand_total_dividends, 2); ?></td>
            </tr>
        </tbody>
    </table>
</div>
</body>
</html>