class PaymentService {
    protected $model;
    
    public function __construct($model) {
        $this->model = $model;
    }
    
    public function processPayment($loan_id, $payment_data) {
        $loan = $this->model->getLoanDetails($loan_id);
        $installments = $this->model->getUnpaidInstallments($loan_id);
        
        $remaining_amount = $payment_data['amount'];
        $results = [
            'processed_installments' => 0,
            'total_principal' => 0,
            'total_interest' => 0,
            'remaining_amount' => $remaining_amount,
            'fully_paid' => false
        ];
        
        foreach ($installments as $installment) {
            if ($remaining_amount <= 0) break;
            
            // Calculate how much to allocate to this installment
            $interest_paid = min($remaining_amount, $installment['ltrans_interestdue']);
            $principal_paid = min(
                $remaining_amount - $interest_paid,
                $installment['ltrans_principaldue']
            );
            
            // Record the payment
            $payment_record = [
                'ltrans_id' => $installment['ltrans_id'],
                'cust_id' => $loan['cust_id'],
                'payment_date' => $payment_data['payment_date'],
                'principal_paid' => $principal_paid,
                'interest_paid' => $interest_paid,
                'receipt_no' => $payment_data['receipt_no'],
                'user_id' => $payment_data['user_id']
            ];
            
            if ($this->model->recordPayment($payment_record)) {
                $results['processed_installments']++;
                $results['total_principal'] += $principal_paid;
                $results['total_interest'] += $interest_paid;
                $remaining_amount -= ($principal_paid + $interest_paid);
            }
        }
        
        // Check if loan is fully paid
        $unpaid = $this->model->getUnpaidInstallments($loan_id);
        $results['fully_paid'] = empty($unpaid);
        $results['remaining_amount'] = $remaining_amount;
        
        return $results;
    }
}