<?PHP
	session_start();
	require 'functions.php';
	checkLogin();
	checkPermissionReport();
	$db_link = connect();
	
	//Variable $year provides the pre-set values for input fields
	$year = (date("Y",time()))-1; 
	//echo $year;
?>
<html>
	<?PHP includeHead('Annual Report',1) ?>	
	<body>
		
		<!-- MENU -->
		<?PHP 
				includeMenu(5);
		?>
		
		<!-- MENU MAIN -->
		<div id="menu_main">
			<a href="rep_incomes.php">Income Report</a>
			<a href="rep_expenses.php">Expense Report</a>
			<a href="rep_loans.php">Loans Report</a>
			<a href="rep_capital.php">Capital Report</a>
			<a href="rep_monthly.php">Monthly Report</a>
			<a href="rep_annual.php" id="item_selected">Annual Report</a>
			<a href="rep_mtd.php">Consolidated Report</a>
		</div>
		
		<!-- MENU: Selection Bar -->
		<div id="menu_selection">			
			<form action="rep_annual.php" method="post">
				<input type="number" min="2006" max="2206" name="rep_year" style="width:100px;" value="<?PHP echo $year; ?>" placeholder="Give Year" />
				<input type="submit" name="select" value="Select Report" />
			</form>
		</div>
		
		<?PHP
		if(isset($_POST['select'])){
			
			//Sanitize user input
			$rep_year = sanitize($db_link, $_POST['rep_year']);
			
			//Calculate UNIX TIMESTAMP for first and last day of selected month
			$firstDay = mktime(0, 0, 0, 1, 1, $rep_year); //to consilidate data for two years
			$lastDay = mktime(0, 0, 0, 1, 0, ($rep_year+1));
			
			//Make array for exporting data
			$_SESSION['rep_export'] = array();
			$_SESSION['rep_exp_title'] = $rep_year.'_annual-report';
			
			
			/**** INCOME RELATED DATA ****/

			//Select Share Value 
			$sql_default_share = "SELECT shareval_value FROM `shareval` ORDER BY shareval_value DESC LIMIT 1";
			$query_default_share = mysqli_query($db_link, $sql_default_share);
			checkSQL($db_link, $query_default_share);
			$default_share =0;
			while($row_default_share = mysqli_fetch_assoc($query_default_share)){
				$default_share = $row_default_share['shareval_value'];
			}
			
			//Select INCOMES and INCTYPE
			$sql_incomes = "SELECT * FROM incomes WHERE inc_date BETWEEN $firstDay AND $lastDay";
			$query_incomes = mysqli_query($db_link, $sql_incomes);
			checkSQL($db_link, $query_incomes);
			
			$sql_inctype = "SELECT * FROM inctype";
			$query_inctype = mysqli_query($db_link, $sql_inctype);
			checkSQL($db_link, $query_inctype);

			//Select other incomes excluding intrests 
			$sql_incomes_others = "SELECT *  FROM incomes WHERE inc_date BETWEEN $firstDay AND $lastDay AND inctype_id !='4'";
			$query_incomes_others = mysqli_query($db_link, $sql_incomes_others);
			checkSQL($db_link, $query_incomes_others);
			$total_incomes_others = 0;
			while($row_incomes_others = mysqli_fetch_assoc($query_incomes_others)){
				$total_incomes_others = $total_incomes_others + $row_incomes_others['inc_amount'];
			}

			//Select total income
			$sql_incomes_total = "SELECT *  FROM incomes WHERE inc_date BETWEEN $firstDay AND $lastDay";
			$query_incomes_total = mysqli_query($db_link, $sql_incomes_total);
			checkSQL($db_link, $query_incomes_total);
			$total_incomes = 0;
			while($row_incomes_total = mysqli_fetch_assoc($query_incomes_total)){
				$total_incomes = $total_incomes + $row_incomes_total['inc_amount'];
			}


			//Select total Share Distribution
			$sql_share_customer = "SELECT customer.cust_name, 
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=1),0) as 'JAN',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=2),0) as 'FEB',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=3),0) as 'MAR',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=4),0) as 'APR',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=5),0) as 'MAY',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=6),0) as 'JUN',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=7),0) as 'JUL',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=8),0) as 'AUG',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=9),0) as 'SEP',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=10),0) as 'OCT',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=11),0) as 'NOV',
IFNULL((SELECT SUM(shares.share_amount) FROM shares WHERE customer.cust_id= shares.cust_id AND share_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(share_date,'%Y-%m-%d'))=12),0) as 'DEC' FROM customer, shares WHERE share_date BETWEEN $firstDay AND $lastDay AND customer.cust_active =1 GROUP BY customer.cust_name";
			$query_share_customer = mysqli_query($db_link, $sql_share_customer);
			checkSQL($db_link, $query_share_customer);
		
			//Select total Social Fund Distribution
			$sql_saving_customer = "SELECT customer.cust_name, 
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=1),0) as 'JAN',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=2),0) as 'FEB',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=3),0) as 'MAR',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=4),0) as 'APR',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=5),0) as 'MAY',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=6),0) as 'JUN',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=7),0) as 'JUL',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=8),0) as 'AUG',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=9),0) as 'SEP',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=10),0) as 'OCT',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=11),0) as 'NOV',
IFNULL((SELECT SUM(savings.sav_amount) FROM savings WHERE customer.cust_id= savings.cust_id AND sav_date BETWEEN $firstDay AND $lastDay AND MONTH(from_unixtime(sav_date,'%Y-%m-%d'))=12),0) as 'DEC'
FROM customer, savings WHERE sav_date BETWEEN $firstDay AND $lastDay AND customer.cust_active =1 GROUP BY customer.cust_name";
			$query_saving_customer = mysqli_query($db_link, $sql_saving_customer);
			checkSQL($db_link, $query_saving_customer);


			/**** EXPENDITURE RELATED DATA ****/
			
			//Select expenses and EXPTYPE
			$sql_expendit = "SELECT * FROM expenses WHERE exp_date BETWEEN $firstDay AND $lastDay ORDER BY exp_date";
			$query_expendit = mysqli_query($db_link, $sql_expendit);
			checkSQL($db_link, $query_expendit);
			
			$sql_exptype = "SELECT * FROM exptype";
			$query_exptype = mysqli_query($db_link, $sql_exptype);
			checkSQL($db_link, $query_exptype);
			
			
			/**** CAPITAL RELATED DATA ****/
			
			//Select bought and sold Shares from SHARES
			$sql_shares = "SELECT * FROM shares WHERE share_date BETWEEN $firstDay AND $lastDay";
			$query_shares = mysqli_query($db_link, $sql_shares);
			checkSQL($db_link, $query_shares);
			$total_share_buys = 0;
			$total_share_sales = 0;
			while($row_shares = mysqli_fetch_assoc($query_shares)){
				if($row_shares['share_amount'] >= 0){
					$total_share_buys = $total_share_buys + $row_shares['share_value'];
				}
				elseif($row_shares['share_amount'] < 0){
					$total_share_sales = $total_share_sales + $row_shares['share_value'] * (-1);
				}
			}

			$sql_shares_total = "SELECT * FROM shares WHERE share_date BETWEEN $firstDay AND $lastDay";
			$query_shares_total = mysqli_query($db_link, $sql_shares_total);
			checkSQL($db_link, $query_shares_total);
			$total_shares = 0;
			while($row_total_shares = mysqli_fetch_assoc($query_shares_total)){
				$total_shares = $total_shares + $row_total_shares['share_amount'];
			}
			

			//Select Saving Deposits from SAVINGS
			$sql_savdep = "SELECT * FROM savings WHERE sav_date BETWEEN $firstDay AND $lastDay AND savtype_id = 1";
			$query_savdep = mysqli_query($db_link, $sql_savdep);
			checkSQL($db_link, $query_savdep);
			$total_savdep = 0;
			while($row_savdep = mysqli_fetch_assoc($query_savdep)){
				$total_savdep = $total_savdep + $row_savdep['sav_amount'];
			}
			
			//Select Loan Recoveries from LOANS
			$sql_loanrec = "SELECT * FROM ltrans WHERE ltrans_date BETWEEN $firstDay AND $lastDay";
			$query_loanrec = mysqli_query($db_link, $sql_loanrec);
			checkSQL($db_link, $query_loanrec);
			$total_loanrec = 0;
			while($row_loanrec = mysqli_fetch_assoc($query_loanrec)){
				$total_loanrec = $total_loanrec + $row_loanrec['ltrans_principal'];
			}
			
			//Select Saving Withdrawals from SAVINGS
			$sql_savwithd = "SELECT * FROM savings WHERE sav_date BETWEEN $firstDay AND $lastDay AND savtype_id = 2";
			$query_savwithd = mysqli_query($db_link, $sql_savwithd);
			checkSQL($db_link, $query_savwithd);
			$total_savwithd = 0;
			while($row_savwithd = mysqli_fetch_assoc($query_savwithd)){
				$total_savwithd = $total_savwithd + $row_savwithd['sav_amount'];
			}
			$total_savwithd = $total_savwithd * (-1);
			
			//Select Loans Out from LOANS
			$sql_loanout = "SELECT * FROM loans WHERE loan_dateout BETWEEN $firstDay AND $lastDay";
			$query_loanout = mysqli_query($db_link, $sql_loanout);
			checkSQL($db_link, $query_loanout);
			$total_loanout = 0;
			while($row_loanout = mysqli_fetch_assoc($query_loanout)){
				$total_loanout = $total_loanout + $row_loanout['loan_principal'];
			}

			
			/**** LOAN RELATED DATA ****/
			
			//Select Due Loan Payments from LTRANS
			$sql_loandue = "SELECT * FROM ltrans, loans, loanstatus WHERE ltrans.loan_id = loans.loan_id AND loans.loanstatus_id = loanstatus.loanstatus_id AND ltrans_due BETWEEN $firstDay AND $lastDay AND loans.loanstatus_id IN (2, 4, 5) ORDER BY ltrans_due, loans.cust_id";
			$query_loandue = mysqli_query($db_link, $sql_loandue);
			checkSQL($db_link, $query_loandue);

			//Select Not cleared Loans from LTRANS
			$sql_loancleared = "SELECT * FROM ltrans, loans, loanstatus, customer WHERE ltrans.loan_id = loans.loan_id AND loans.loanstatus_id = loanstatus.loanstatus_id AND loans.cust_id = customer.cust_id AND ltrans_due BETWEEN $firstDay AND $lastDay AND loans.loanstatus_id IN (2) GROUP BY loans.loan_id ORDER BY loans.loan_interest, loans.loan_repaytotal, ltrans_due ";
			$query_loancleared = mysqli_query($db_link, $sql_loancleared);
			checkSQL($db_link, $query_loancleared);
			
			//Select Agents Combined shares, Social Fund from ltrans, loans, loanstatus, customer, savbalance, shares
			$sql_combined = "SELECT savings.cust_id, SUM(savings.sav_amount)AS sav_amount, customer.cust_name FROM  savings, customer WHERE customer.cust_id=savings.cust_id AND savings.sav_date BETWEEN $firstDay AND $lastDay  GROUP BY cust_id ORDER BY cust_id ";
			$query_combined = mysqli_query($db_link, $sql_combined);
			checkSQL($db_link, $query_combined);

			//New Share Value to identified Customers 
			$sql_payout = "SELECT DISTINCT customer.cust_id, customer.cust_name FROM customer,loans WHERE customer.cust_id=loans.cust_id AND loans.loan_interest='10' AND loans.loan_date BETWEEN $firstDay AND $lastDay ORDER BY customer.cust_id";
			$query_payout = mysqli_query($db_link, $sql_payout);
			checkSQL($db_link, $query_payout);

			//Used to get total valid payouts
			$sql_payouts = "SELECT DISTINCT customer.cust_id, customer.cust_name FROM customer,loans WHERE customer.cust_id=loans.cust_id AND loans.loan_interest='10' AND loans.loan_date BETWEEN $firstDay AND $lastDay ";
			$query_payouts = mysqli_query($db_link, $sql_payouts);
			checkSQL($db_link, $query_payouts);


			//Used to get total invalid payouts
			$sql_payouts_other = "SELECT DISTINCT customer.cust_name,customer.cust_id FROM customer WHERE NOT EXISTS (SELECT * FROM loans WHERE customer.cust_id=loans.cust_id AND loans.loan_interest='10' AND  loans.loan_date BETWEEN $firstDay AND $lastDay) ";
			$query_payouts_other = mysqli_query($db_link, $sql_payouts_other);
			checkSQL($db_link, $query_payouts_other);
			//Used to get total invalid payouts
			$sql_payouts_others = "SELECT DISTINCT customer.cust_name,customer.cust_id FROM customer WHERE NOT EXISTS (SELECT * FROM loans WHERE customer.cust_id=loans.cust_id AND loans.loan_interest='10' AND loans.loan_date BETWEEN $firstDay AND $lastDay) ";
			$query_payouts_others = mysqli_query($db_link, $sql_payouts_others);
			checkSQL($db_link, $query_payouts_others);

			//Select Loan Recoveries from LTRANS
			$sql_loanrec = "SELECT * FROM ltrans, loans WHERE ltrans.loan_id = loans.loan_id AND ltrans_date BETWEEN $firstDay AND $lastDay ORDER BY ltrans_date, loans.cust_id";
			$query_loanrec = mysqli_query($db_link, $sql_loanrec);
			checkSQL($db_link, $query_loanrec);
			
			//Select Loans Out from LOANS
			$sql_loanout = "SELECT * FROM loans, customer WHERE loans.cust_id = customer.cust_id AND loans.loan_dateout BETWEEN $firstDay AND $lastDay ORDER BY loan_dateout, loans.cust_id";
			$query_loanout = mysqli_query($db_link, $sql_loanout);
			checkSQL($db_link, $query_loanout);
			?>	
									
			<!-- Export Button -->					
			<form class="export" action="rep_export.php" method="post">
				<input type="submit" name="export_rep" value="Export Report" />
			</form>
				
			
			<!-- LOANS: Table 1: Due Repayments -->
			<?PHP array_push($_SESSION['rep_export'], array("Type" => "LOAN REPAYMENTS", "Amount" => "")); ?>
			<table id="tb_table" style="width:75%">
				<colgroup>
					<col width="25%"/>
					<col width="25%"/>
					<col width="25%"/>
					<col width="25%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="4">Due Loan Payments for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Loan No.</th>
					<th>Loan Status</th>
					<th>Due Date</th>
					<th>Due Amount</th>
				</tr>
				<?PHP
				$total_loandue = 0;
				while($row_loandue = mysqli_fetch_assoc($query_loandue)){
					echo '<tr>
									<td><a href="loan.php?lid='.$row_loandue['loan_id'].'">'.$row_loandue['loan_no'].'</a></td>
									<td>'.$row_loandue['loanstatus_status'].'</td>
									<td>'.date("d.m.Y",$row_loandue['ltrans_due']).'</td>
									<td>'.number_format($row_loandue['ltrans_principaldue'] + $row_loandue['ltrans_interestdue']).' '.$_SESSION['set_cur'].'</td>										
								</tr>';
					$total_loandue = $total_loandue + $row_loandue['ltrans_principaldue'] + $row_loandue['ltrans_interestdue'];
				}
				echo '<tr class="balance">
								<td colspan="4">Total Due Payments: '.number_format($total_loandue).' '.$_SESSION['set_cur'].'</td>
							</tr>';
				
				//Prepare LOAN REPAYMENT data for export to Excel file
				array_push($_SESSION['rep_export'], array("Type" => "Due Loan Payments", "Amount" => $total_loandue));
				?>				
			</table>
			
			<!-- LOANS: Table 2: Loan Recoveries --> 
			<table id="tb_table" style="width:75%">
				<colgroup>
					<col width="25%"/>
					<col width="25%"/>
					<col width="25%"/>
					<col width="25%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="4">Loan Recoveries for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Loan No.</th>
					<th>Instalment Due</th>
					<th>Recovered</th>
					<th>Date</th>
				</tr>
				<?PHP
				$total_loanrec = 0;
				while($row_loanrec = mysqli_fetch_assoc($query_loanrec)){
					echo '<tr>
									<td><a href="loan.php?lid='.$row_loanrec['loan_id'].'">'.$row_loanrec['loan_no'].'</a></td>
									<td>'.number_format($row_loanrec['ltrans_principaldue'] + $row_loanrec['ltrans_interestdue']).' '.$_SESSION['set_cur'].'</td>
									<td>'.number_format($row_loanrec['ltrans_principal'] + $row_loanrec['ltrans_interest']).' '.$_SESSION['set_cur'].'</td>
									<td>'.date("d.m.Y",$row_loanrec['ltrans_date']).'</td>
								</tr>';
					$total_loanrec = $total_loanrec + $row_loanrec['ltrans_principal'] + $row_loanrec['ltrans_interest'];
				}
				echo '<tr class="balance">
								<td colspan="4">
									Total Recoveries: '.number_format($total_loanrec).' '.$_SESSION['set_cur'];
				if ($total_loandue != 0) echo '<br/>Loan Recovery Rate: '.number_format($total_loanrec / $total_loandue * 100).'%';
				echo '	</td>
							</tr>';
							
				//Prepare LOANS RECOVERY data for export to Excel file
				array_push($_SESSION['rep_export'], array("Type" => "Loan Recoveries", "Amount" => $total_loanrec));
				if ($total_loandue != 0) array_push($_SESSION['rep_export'], array("Type" => "Loan Recovery Rate", "Amount" => round(($total_loanrec / $total_loandue * 100),2).'%'));
				array_push($_SESSION['rep_export'], array("Type" => "", "Amount" => ""));
				?>				
			</table>
			
			<!-- LOANS: Table 3: Loans Out -->
			<table id="tb_table" style="width:75%">
				<colgroup>
					<col width="10%"/>
					<col width="20%"/>
					<col width="20%"/>
					<col width="5%"/>
					<col width="5%"/>
					<col width="20%"/>
					<col width="10%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="8">Loans Out for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Loan No.</th>
					<th>Customer</th>
					<th>Principal</th>
					<th>Interest</th>
					<th>Period</th>
					<th>Repay Total</th>
					<th>Date Out</th>
					<th>Remaining Balance</th>
				</tr>
				<?PHP
				$testmay =0;
				$total_loanout = 0;
				while($row_loanout = mysqli_fetch_assoc($query_loanout)){
				$testmay =$row_loanout['loan_id'];

					$sql ="SELECT (SUM(ltrans_principal) + SUM(ltrans_interest)) AS ipaid FROM ltrans WHERE loan_id =$testmay AND ltrans_date BETWEEN $firstDay AND $lastDay ";
					$result = mysqli_query($db_link, $sql);
					$row = mysqli_fetch_assoc($result);
				
					echo '<tr>
									<td><a href="loan.php?lid='.$row_loanout['loan_id'].'">'.$row_loanout['loan_no'].'</a></td>
									<td>'.$row_loanout['cust_name'].' ('.$row_loanout['cust_no'].')</td>
									<td>'.number_format($row_loanout['loan_principal']).' '.$_SESSION['set_cur'].'</td>
									<td>'.$row_loanout['loan_interest'].'%</td>
									<td>'.$row_loanout['loan_period'].'</td>
									<td>'.number_format($row_loanout['loan_repaytotal']).' '.$_SESSION['set_cur'].'</td>
									<td>'.date("d.m.Y", $row_loanout['loan_dateout']).'</td>
									<td>'.number_format(($row['ipaid']-$row_loanout['loan_repaytotal'])).' '.$_SESSION['set_cur'].
									'</td>
									
								</tr>';
					$total_loanout = $total_loanout + $row_loanout['loan_principal'];
				}
				echo '<tr class="balance">
								<td colspan="8">Total Loans Out: '.number_format($total_loanout).' '.$_SESSION['set_cur'].'</td>
							</tr>';
				?>
			</table>
			
				<!-- INCOMES: Table 1 -->
			<?PHP array_push($_SESSION['rep_export'], array("Type" => "INCOMES", "Amount" => "")); ?>
			<table id="tb_table" style="width:50%">
				<colspan>
					<col width="50%">
					<col width="50%">
				</colspan>
				<tr>
					<th class="title" colspan="2">Incomes for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Type</th>
					<th>Amount</th>
				</tr>
				<?PHP
				//Make array for income types
				$inctype = array();
				while($row_inctype = mysqli_fetch_assoc($query_inctype)){
					$inctype[] = $row_inctype;
				}
				
				//Make array for all incomes for selected month
				$incomes = array();
				while($row_incomes = mysqli_fetch_assoc($query_incomes)){
					$incomes[] = $row_incomes;
				}
				
				//Iterate over income types and add matching incomes to $total
				$total_inc = 0;
				foreach ($inctype as $it){
					$total_row = 0;
					foreach ($incomes as $ic) if ($ic['inctype_id'] == $it['inctype_id']) $total_row = $total_row + $ic['inc_amount'];
					echo '<tr>
									<td>'.$it['inctype_type'].'</td>
									<td>'.number_format($total_row).' '.$_SESSION['set_cur'].'</td>
								</tr>';	
					$total_inc = $total_inc + $total_row;	
					
					//Prepare INCOME data for export to Excel file
					array_push($_SESSION['rep_export'], array("Type" => $it['inctype_type'], "Amount" => $total_row));
				}
				
				//Total Incomes Amount
				echo '	<tr class="balance">
									<td>Total Incomes:</td>
									<td>'.number_format($total_inc).' '.$_SESSION['set_cur'].'</td>
								</tr>';
				array_push($_SESSION['rep_export'], array("Type" => "Total Incomes", "Amount" => $total_inc));
				array_push($_SESSION['rep_export'], array("Type" => "", "Amount" => ""));
				?>
			</table>
			
			<!-- Expenses: Table 1 -->

			
			<?PHP array_push($_SESSION['rep_export'], array("Type" => "EXPENSES", "Amount" => "")); ?>
			<table id="tb_table" style="width:50%">
				<colspan>
					<col width="50%">
					<col width="50%">
				</colspan>
				<tr>
					<th class="title" colspan="2">Expenses for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Type</th>
					<th>Amount</th>
				</tr>
				<?PHP
				
				$exptype = array();
				while($row_exptype = mysqli_fetch_assoc($query_exptype)){
					$exptype[] = $row_exptype;
				}
				
				$expendit = array();
				while($row_expendit = mysqli_fetch_assoc($query_expendit)){
					$expendit[] = $row_expendit;
				}
				
				$total_exp = 0;
				foreach ($exptype as $et){
					$total_row = 0;
					foreach ($expendit as $ex) if ($ex['exptype_id'] == $et['exptype_id']) $total_row = $total_row + $ex['exp_amount'];
					echo '<tr>
									<td>'.$et['exptype_type'].'</td>
									<td>'.number_format($total_row).' '.$_SESSION['set_cur'].'</td>
								</tr>';
					$total_exp = $total_exp + $total_row;	
					
					//Prepare EXPENSE data for export to Excel file
					array_push($_SESSION['rep_export'], array("Type" => $et['exptype_type'], "Amount" => $total_row));
				}
				
				//Total expenses Amount Line
				echo '<tr class="balance">
								<td>Total expenses:</td>
								<td>'.number_format($total_exp).' '.$_SESSION['set_cur'].'</td>
							</tr>';
				array_push($_SESSION['rep_export'], array("Type" => "Total expenses", "Amount" => $total_exp));
				array_push($_SESSION['rep_export'], array("Type" => "", "Amount" => ""));
				?>
			</table>


<!-- Customer Monthly Shares Dsitibution: Table 1: Due Repayments -->
			<?PHP array_push($_SESSION['rep_export'], array("Type" => "Customer Monthly Shares Distribution ", "Amount" => "")); ?>
			<table id="tb_table" style="width:75%">
				<colgroup>
					<col width="10%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					
				</colgroup>
				<tr>
					<th class="title" colspan="14"> Customer Monthly Shares Distribution for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Name </th>
					<th>January</th>
					<th>February</th>
					<th>March</th>
					<th>April</th>
					<th>May</th>
					<th>June</th>
					<th>July</th>
					<th>August</th>
					<th>September</th>
					<th>October</th>
					<th>November</th>
					<th>December</th>
					<th class="title">Total</th>
				</tr>
				<?PHP
				$total_shares_jan =0;
				$total_shares_feb =0;
				$total_shares_mac =0;
				$total_shares_apr =0;
				$total_shares_may =0;
				$total_shares_jun =0;
				$total_shares_jul =0;
				$total_shares_aug =0;
				$total_shares_sep =0;
				$total_shares_oct =0;
				$total_shares_nov =0;
				$total_shares_dec =0;
				$total_shares_total=0;

				while($row_total_share_customer = mysqli_fetch_assoc($query_share_customer)){

					echo '<tr>
									<td>'.$row_total_share_customer['cust_name'].'</td>
									<td>'.$row_total_share_customer['JAN'].'</td>
									<td>'.$row_total_share_customer['FEB'].'</td>
									<td>'.$row_total_share_customer['MAR'].'</td>
									<td>'.$row_total_share_customer['APR'].'</td>
									<td>'.$row_total_share_customer['MAY'].'</td>
									<td>'.$row_total_share_customer['JUN'].'</td>
									<td>'.$row_total_share_customer['JUL'].'</td>
									<td>'.$row_total_share_customer['AUG'].'</td>
									<td>'.$row_total_share_customer['SEP'].'</td>
									<td>'.$row_total_share_customer['OCT'].'</td>
									<td>'.$row_total_share_customer['NOV'].'</td>
									<td>'.$row_total_share_customer['DEC'].'</td>

									<td>'.number_format($row_total_share_customer['JAN'] + $row_total_share_customer['FEB'] + $row_total_share_customer['MAR']+$row_total_share_customer['APR']+$row_total_share_customer['MAY']+$row_total_share_customer['JUN']+$row_total_share_customer['JUL']+$row_total_share_customer['AUG']+$row_total_share_customer['SEP']+$row_total_share_customer['OCT']+$row_total_share_customer['NOV']+$row_total_share_customer['DEC']).'</td>
									
									
								</tr>';
									$total_shares_jan = $total_shares_jan + $row_total_share_customer['JAN'];
									$total_shares_feb = $total_shares_feb + $row_total_share_customer['FEB'];
									$total_shares_mac = $total_shares_mac + $row_total_share_customer['MAR'];
									$total_shares_apr = $total_shares_apr + $row_total_share_customer['APR'];
									$total_shares_may = $total_shares_may + $row_total_share_customer['MAY'];
									$total_shares_jun = $total_shares_jun + $row_total_share_customer['JUN'];
									$total_shares_jul = $total_shares_jul + $row_total_share_customer['JUL'];
									$total_shares_aug = $total_shares_aug + $row_total_share_customer['AUG'];
									$total_shares_sep = $total_shares_sep + $row_total_share_customer['SEP'];
									$total_shares_oct = $total_shares_oct + $row_total_share_customer['OCT'];
									$total_shares_nov = $total_shares_nov + $row_total_share_customer['NOV'];
									$total_shares_dec = $total_shares_dec + $row_total_share_customer['DEC'];
									$total_shares_total =$total_shares_jan+$total_shares_feb+$total_shares_mac+$total_shares_apr+$total_shares_may+$total_shares_jun+$total_shares_jul+$total_shares_aug+$total_shares_sep+$total_shares_oct+$total_shares_nov+$total_shares_dec;
				}

				echo '<tr class="balance">
				  <td> Total</td>
				  <td>'.number_format($total_shares_jan).'</td>
				  <td>'.number_format($total_shares_feb).'</td>
				  <td>'.number_format($total_shares_mac).'</td>
				  <td>'.number_format($total_shares_apr).'</td>
				  <td>'.number_format($total_shares_may).'</td>
				  <td>'.number_format($total_shares_jun).'</td>
				  <td>'.number_format($total_shares_jul).'</td>
				  <td>'.number_format($total_shares_aug).'</td>
				  <td>'.number_format($total_shares_sep).'</td>
				  <td>'.number_format($total_shares_oct).'</td>
				  <td>'.number_format($total_shares_nov).'</td>
				  <td>'.number_format($total_shares_dec).'</td>
				  <td>'.number_format($total_shares_total).'</td>
				</tr>

				<tr class="title">
				  <td> Total Value</td>
				  <td>'.number_format(($total_shares_jan*$default_share)).'</td>
				  <td>'.number_format($total_shares_feb*$default_share).'</td>
				  <td>'.number_format($total_shares_mac*$default_share).'</td>
				  <td>'.number_format($total_shares_apr*$default_share).'</td>
				  <td>'.number_format($total_shares_may*$default_share).'</td>
				  <td>'.number_format($total_shares_jun*$default_share).'</td>
				  <td>'.number_format($total_shares_jul*$default_share).'</td>
				  <td>'.number_format($total_shares_aug*$default_share).'</td>
				  <td>'.number_format($total_shares_sep*$default_share).'</td>
				  <td>'.number_format($total_shares_oct*$default_share).'</td>
				  <td>'.number_format($total_shares_nov*$default_share).'</td>
				  <td>'.number_format($total_shares_dec*$default_share).'</td>
				  <td>'.number_format($total_shares_total*$default_share).'</td>
				</tr>'
				;						


					;
				
				//Prepare LOAN Balance data for export to Excel file
			//	array_push($_SESSION['rep_export'], array("Type" => "Loan Balances", "Amount" => $total_loancleared));
				?>				
			</table>


<!-- Customer Monthly Social Fund Dsitibution: Table 1: Due Repayments -->
			<?PHP array_push($_SESSION['rep_export'], array("Type" => "Customer Monthly Social Fund Distribution ", "Amount" => "")); ?>
			<table id="tb_table" style="width:75%">
				<colgroup>
					<col width="10%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					<col width="7%"/>
					
				</colgroup>
				<tr>
					<th class="title" colspan="14"> Customer Monthly Social Fund Distribution for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Name </th>
					<th>January</th>
					<th>February</th>
					<th>March</th>
					<th>April</th>
					<th>May</th>
					<th>June</th>
					<th>July</th>
					<th>August</th>
					<th>September</th>
					<th>October</th>
					<th>November</th>
					<th>December</th>
					<th class="title">Total</th>
				</tr>
				<?PHP

				$total_saving_jan =0;
				$total_saving_feb =0;
				$total_saving_mac =0;
				$total_saving_apr =0;
				$total_saving_may =0;
				$total_saving_jun =0;
				$total_saving_jul =0;
				$total_saving_aug =0;
				$total_saving_sep =0;
				$total_saving_oct =0;
				$total_saving_nov =0;
				$total_saving_dec =0;
				$total_saving_total=0;

				while($row_total_saving_customer = mysqli_fetch_assoc($query_saving_customer)){

					echo '<tr>
									<td>'.$row_total_saving_customer['cust_name'].'</td>
									<td>'.$row_total_saving_customer['JAN'].'</td>
									<td>'.$row_total_saving_customer['FEB'].'</td>
									<td>'.$row_total_saving_customer['MAR'].'</td>
									<td>'.$row_total_saving_customer['APR'].'</td>
									<td>'.$row_total_saving_customer['MAY'].'</td>
									<td>'.$row_total_saving_customer['JUN'].'</td>
									<td>'.$row_total_saving_customer['JUL'].'</td>
									<td>'.$row_total_saving_customer['AUG'].'</td>
									<td>'.$row_total_saving_customer['SEP'].'</td>
									<td>'.$row_total_saving_customer['OCT'].'</td>
									<td>'.$row_total_saving_customer['NOV'].'</td>
									<td>'.$row_total_saving_customer['DEC'].'</td>

									<td>'.number_format($row_total_saving_customer['JAN'] + $row_total_saving_customer['FEB'] + $row_total_saving_customer['MAR']+$row_total_saving_customer['APR']+$row_total_saving_customer['MAY']+$row_total_saving_customer['JUN']+$row_total_saving_customer['JUL']+$row_total_saving_customer['AUG']+$row_total_saving_customer['SEP']+$row_total_saving_customer['OCT']+$row_total_saving_customer['NOV']+$row_total_saving_customer['DEC']).'</td>
									
									
								</tr>';
									$total_saving_jan = $total_saving_jan + $row_total_saving_customer['JAN'];
									$total_saving_feb = $total_saving_feb + $row_total_saving_customer['FEB'];
									$total_saving_mac = $total_saving_mac + $row_total_saving_customer['MAR'];
									$total_saving_apr = $total_saving_apr + $row_total_saving_customer['APR'];
									$total_saving_may = $total_saving_may + $row_total_saving_customer['MAY'];
									$total_saving_jun = $total_saving_jun + $row_total_saving_customer['JUN'];
									$total_saving_jul = $total_saving_jul + $row_total_saving_customer['JUL'];
									$total_saving_aug = $total_saving_aug + $row_total_saving_customer['AUG'];
									$total_saving_sep = $total_saving_sep + $row_total_saving_customer['SEP'];
									$total_saving_oct = $total_saving_oct + $row_total_saving_customer['OCT'];
									$total_saving_nov = $total_saving_nov + $row_total_saving_customer['NOV'];
									$total_saving_dec = $total_saving_dec + $row_total_saving_customer['DEC'];
									$total_saving_total =$total_saving_jan+$total_saving_feb+$total_saving_mac+$total_saving_apr+$total_saving_may+$total_saving_jun+$total_saving_jul+$total_saving_aug+$total_saving_sep+$total_saving_oct+$total_saving_nov+$total_saving_dec;
				}

				echo '<tr class="balance">

				  <td> Total</td>
				  <td>'.number_format($total_saving_jan).'</td>
				  <td>'.number_format($total_saving_feb).'</td>
				  <td>'.number_format($total_saving_mac).'</td>
				  <td>'.number_format($total_saving_apr).'</td>
				  <td>'.number_format($total_saving_may).'</td>
				  <td>'.number_format($total_saving_jun).'</td>
				  <td>'.number_format($total_saving_jul).'</td>
				  <td>'.number_format($total_saving_aug).'</td>
				  <td>'.number_format($total_saving_sep).'</td>
				  <td>'.number_format($total_saving_oct).'</td>
				  <td>'.number_format($total_saving_nov).'</td>
				  <td>'.number_format($total_saving_dec).'</td>
				  <td>'.number_format($total_saving_total).'</td>

				</tr>';							;
				
				//Prepare LOAN Balance data for export to Excel file
			//	array_push($_SESSION['rep_export'], array("Type" => "Loan Balances", "Amount" => $total_loancleared));
				?>				
			</table>
	
			

					<!-- Customer Distributions : Table 1: Due Repayments -->
			<?PHP array_push($_SESSION['rep_export'], array("Type" => "Customer Distribution Report", "Amount" => "")); ?>
			<table id="tb_table" style="width:75%">
				<colgroup>
					<col width="15%"/>
					<col width="15%"/>
					<col width="15%"/>
					<col width="15%"/>
					<col width="15%"/>
					
				</colgroup>
				<tr>
					<th class="title" colspan="5"> Contribution Distributions for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Name </th>
					<th>Shares Acquired</th>
					<th>Initial Share Value</th>
					<th>Loan Factor</th>
					<th>Social Fund Contribution</th>
				</tr>
				<?PHP

				$total_social_combined =0;
				$total_vshares_combined =0 ;
				$total_shares_combined =0 ;
				$cust_id_combined =0;
				$total_loancleared = 0;
				while($row_combined = mysqli_fetch_assoc($query_combined)){

					$cust_id_combined =$row_combined['cust_id'];

					$sql_combined_shares ="SELECT SUM(share_amount) AS tshares FROM shares WHERE cust_id = $cust_id_combined AND share_date BETWEEN $firstDay AND $lastDay";
					$result_combined_shares = mysqli_query($db_link, $sql_combined_shares);
					$row_combined_shares = mysqli_fetch_assoc($result_combined_shares);


					$sql_combined_vshares ="SELECT SUM(share_value) AS vshares FROM shares WHERE cust_id = $cust_id_combined AND share_date BETWEEN $firstDay AND $lastDay";
					$result_combined_vshares = mysqli_query($db_link, $sql_combined_vshares);
					$row_combined_vshares = mysqli_fetch_assoc($result_combined_vshares);


					echo '<tr>
									<td>'.$row_combined['cust_name'].'</td>
									<td>'.$row_combined_shares['tshares'].'</td>
									<td>'.number_format($row_combined_vshares['vshares']).' '.$_SESSION['set_cur'].'</td>
									<td>'.number_format($row_combined_vshares['vshares']*3).' '.$_SESSION['set_cur'].'</td>
									<td>'.$row_combined['sav_amount'].' '.$_SESSION['set_cur'].'</td>
									
								</tr>';

					$total_shares_combined = $total_shares_combined + $row_combined_shares['tshares'];
					$total_vshares_combined = $total_vshares_combined + $row_combined_vshares['vshares'];
					$total_social_combined = $total_social_combined + $row_combined['sav_amount'];

				
				}

				echo '<tr class="balance">
							<td>Total</td>
							<td>'.number_format($total_shares_combined).'</td>
							<td>'.number_format($total_vshares_combined).' '.$_SESSION['set_cur'].'</td>
								<td>'.number_format($total_vshares_combined*3).' '.$_SESSION['set_cur'].'</td>
							<td>'.number_format($total_social_combined).' '.$_SESSION['set_cur'].'</td>
				</tr>';							;
				
				//Prepare LOAN Balance data for export to Excel file
				array_push($_SESSION['rep_export'], array("Type" => "Loan Balances", "Amount" => $total_loancleared));
				?>				
			</table>


					
					<!-- Payout Distributions : Table 1: Due Repayments -->
			<?PHP array_push($_SESSION['rep_export'], array("Type" => "Payout Distribution Report", "Amount" => "")); ?>
			<table id="tb_table" style="width:75%">
				<colgroup>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="8"> Payout Distributions for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Name </th>
					<th>Shares Acquired</th>
					<th>Initial Share Value</th>
					<th>Current Share Value</th>
					<th>Share Dividend </th>
					<th>Loan Balance </th>
					<th>Total Payout </th>
				</tr>
				<?PHP

				// To get total valid share payouts 
				$total_vshares_payouts=0;
				$total_shares_payouts =0 ;
				$cust_id_payouts =0;
				while($row_payouts = mysqli_fetch_assoc($query_payouts)){


					$cust_id_payouts =$row_payouts['cust_id'];


					$sql_payouts_shares ="SELECT SUM(share_amount) AS tshares, SUM(share_value) AS vshares FROM shares WHERE cust_id = $cust_id_payouts AND share_date BETWEEN $firstDay AND $lastDay ";
					$result_payouts_shares = mysqli_query($db_link, $sql_payouts_shares);
					$row_payouts_shares = mysqli_fetch_assoc($result_payouts_shares);

					$total_shares_payouts = $total_shares_payouts + $row_payouts_shares['tshares'];
					$total_vshares_payouts = $total_vshares_payouts + $row_payouts_shares['vshares'];

				
				}
				$total_social_payout=0;
				$total_figure_payout=0;
				$total_loans_payout=0;
				$total_share_dividends= 0;
				$total_vshares_payout= 0;
				$total_nvshares_payout =0 ;
				$total_shares_payout =0 ;
				$cust_id_payout =0;
				while($row_payout = mysqli_fetch_assoc($query_payout)){


					$cust_id_payout =$row_payout['cust_id'];

					$sql_payout_shares ="SELECT loans.cust_id,(SELECT SUM(sav_amount) FROM savings WHERE savings.cust_id=loans.cust_id AND savings.sav_date BETWEEN $firstDay AND $lastDay) AS savbal_balance,(SELECT cust_name FROM customer WHERE customer.cust_id=loans.cust_id) AS cust_name, (SELECT SUM(shares.share_amount ) FROM shares WHERE shares.cust_id=loans.cust_id AND shares.share_date BETWEEN $firstDay AND $lastDay) AS tshares, (SELECT SUM(shares.share_value) FROM shares WHERE shares.cust_id=loans.cust_id AND shares.share_date BETWEEN $firstDay AND $lastDay) AS vshares ,(SUM(ltrans.ltrans_principaldue)+SUM(ltrans.ltrans_interestdue)) AS loan, (SUM(ltrans.ltrans_principal)+SUM(ltrans.ltrans_interest)) AS ipaid FROM ltrans, loans WHERE loans.loan_id=ltrans.loan_id AND loans.loan_date BETWEEN $firstDay AND $lastDay AND loans.cust_id=$cust_id_payout GROUP BY loans.cust_id ";
					$result_payout_shares = mysqli_query($db_link, $sql_payout_shares);
					$row_payout_shares = mysqli_fetch_assoc($result_payout_shares);


					echo '<tr>
									<td>'.$row_payout['cust_name'].'</td>
									<td>'.$row_payout_shares['tshares'].'</td>
									<td>'.number_format($row_payout_shares['vshares']).' '.$_SESSION['set_cur'].'</td>
									<td>'.number_format($row_payout_shares['tshares']*(($total_vshares_payouts + $total_incomes+$total_share_sales)/$total_shares_payouts)).' '.$_SESSION['set_cur'].'</td>
									<td>'.number_format(($row_payout_shares['tshares']*(($total_vshares_payouts + $total_incomes+$total_share_sales)/$total_shares_payouts)) -$row_payout_shares['vshares'] ).' '.$_SESSION['set_cur'].'</td>	
									<td>'.number_format($row_payout_shares['ipaid']-$row_payout_shares['loan']).' '.$_SESSION['set_cur'].'</td>	
									<td>'.number_format(($row_payout_shares['tshares']*(($total_vshares_payouts + $total_incomes)/$total_shares_payouts))+$row_payout_shares['ipaid']-$row_payout_shares['loan'] ).' '.$_SESSION['set_cur'].'</td>					

								</tr>';

					$total_shares_payout = $total_shares_payout + $row_payout_shares['tshares'];
					$total_vshares_payout = $total_vshares_payout + $row_payout_shares['vshares'];
					$total_nvshares_payout = $total_nvshares_payout + ($row_payout_shares['tshares']*(($total_vshares_payouts + $total_incomes)/$total_shares_payouts));
					$total_share_dividends=$total_share_dividends + (($row_payout_shares['tshares']*(($total_vshares_payouts + $total_incomes)/$total_shares_payouts)) -$row_payout_shares['vshares']);
					$total_loans_payout= $total_loans_payout + ($row_payout_shares['ipaid']-$row_payout_shares['loan']);
					$total_figure_payout= $total_figure_payout + (($row_payout_shares['tshares']*(($total_vshares_payouts + $total_incomes)/$total_shares_payouts))+$row_payout_shares['ipaid']-$row_payout_shares['loan']);
				//	$total_social_payout= $total_social_payout +(($row_payout_shares['savbal_balance']) > 54999 ? 0 : $row_payout_shares['savbal_balance']-55000);

				
				}

				echo '<tr class="balance">
							<td>Total</td>
							<td>'.number_format($total_shares_payout).'</td>
							<td>'.number_format($total_vshares_payout).'</td>
							<td>'.number_format($total_nvshares_payout).' '.$_SESSION['set_cur'].'</td>
							<td>'.number_format($total_share_dividends).' '.$_SESSION['set_cur'].'</td>
							<td>'.number_format($total_loans_payout).' '.$_SESSION['set_cur'].'</td>
							<td>'.number_format($total_figure_payout).' '.$_SESSION['set_cur'].'</td>
				</tr>';							;
				
				//Prepare LOAN Balance data for export to Excel file
				array_push($_SESSION['rep_export'], array("Type" => "Payout Distribution", "Amount" => $total_nvshares_payout));
				?>				
			</table>



<!-- Other Payout Distributions : Table 1: Due Repayments -->
			<?PHP array_push($_SESSION['rep_export'], array("Type" => "Other Payout Report", "Amount" => "")); ?>
			<table id="tb_table" style="width:75%">
				<colgroup>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="7">  Other Payout Distributions (No loan Dividend) for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Name </th>
					<th>Shares Acquired</th>
					<th>Initial Share Value</th>
					<th>Current Share Value</th>
					<th>Share Dividend </th>
					<th>Loan Balance </th>
					<th>Total Payout </th>
				</tr>
				<?PHP

				// To get total valid share payouts 
				$total_vshares_payouts_other=0;
				$total_shares_payouts_other =0 ;
				$cust_id_payouts_other =0;
				while($row_payouts_other = mysqli_fetch_assoc($query_payouts_others)){


					$cust_id_payouts_other =$row_payouts_other['cust_id'];


					$sql_payouts_shares_other ="SELECT SUM(share_amount) AS tshares, SUM(share_value) AS vshares FROM shares WHERE cust_id = $cust_id_payouts_other AND share_date BETWEEN $firstDay AND $lastDay ";
					$result_payouts_shares_other = mysqli_query($db_link, $sql_payouts_shares_other);
					$row_payouts_shares_other = mysqli_fetch_assoc($result_payouts_shares_other);

					$total_shares_payouts_other = $total_shares_payouts_other + $row_payouts_shares_other['tshares'];
					$total_vshares_payouts_other = $total_vshares_payouts_other + $row_payouts_shares_other['vshares'];

				
				}
				$total_social_payout_other=0;
				$total_figure_payout_other=0;
				$total_loan_payout_other=0;
				$total_dividend_payout_other=0;
				$total_vshares_payout_other= 0;
				$total_nvshares_payout_other =0 ;
				$total_shares_payout_other =0 ;
				$cust_id_payout_other =0;
				while($row_payout_other = mysqli_fetch_assoc($query_payouts_other)){


					$cust_id_payout_other =$row_payout_other['cust_id'];


					$sql_payout_shares_other ="SELECT loans.cust_id,(SELECT SUM(sav_amount) FROM savings WHERE savings.cust_id=loans.cust_id AND savings.sav_date BETWEEN $firstDay AND $lastDay) AS savbal_balance,(SELECT cust_name FROM customer WHERE customer.cust_id=loans.cust_id) AS cust_name, (SELECT SUM(shares.share_amount ) FROM shares WHERE shares.cust_id=loans.cust_id AND shares.share_date BETWEEN $firstDay AND $lastDay) AS tshares, (SELECT SUM(shares.share_value) FROM shares WHERE shares.cust_id=loans.cust_id AND shares.share_date BETWEEN $firstDay AND $lastDay) AS vshares ,(SUM(ltrans.ltrans_principaldue)+SUM(ltrans.ltrans_interestdue)) AS loan, (SUM(ltrans.ltrans_principal)+SUM(ltrans.ltrans_interest)) AS ipaid FROM ltrans, loans WHERE loans.loan_id=ltrans.loan_id AND loans.cust_id=$cust_id_payout_other  GROUP BY loans.cust_id ";
					$result_payout_shares_other = mysqli_query($db_link, $sql_payout_shares_other);
					$row_payout_shares_other = mysqli_fetch_assoc($result_payout_shares_other);


					echo '<tr>
									<td>'.$row_payout_other['cust_name'].'</td>
									<td>'.$row_payout_shares_other['tshares'].'</td>
									<td>'.number_format($row_payout_shares_other['vshares']).' '.$_SESSION['set_cur'].'</td>
									<td>'.number_format($row_payout_shares_other['vshares']).' '.$_SESSION['set_cur'].'</td>
									<td>'.number_format($row_payout_shares_other['vshares']-$row_payout_shares_other['vshares']).' '.$_SESSION['set_cur'].'</td>
									<td>'.number_format($row_payout_shares_other['ipaid']-$row_payout_shares_other['loan']).' '.$_SESSION['set_cur'].'</td>

									<td>'.number_format($row_payout_shares_other['vshares']+$row_payout_shares_other['ipaid']-$row_payout_shares_other['loan']).' '.$_SESSION['set_cur'].'</td>


								</tr>';


					$total_shares_payout_other = $total_shares_payout_other + $row_payout_shares_other['tshares'];
					$total_vshares_payout_other = $total_vshares_payout_other + $row_payout_shares_other['vshares'];
					$total_dividend_payout_other=$total_dividend_payout_other +($row_payout_shares_other['vshares']-$row_payout_shares_other['vshares']);
					$total_loan_payout_other=$total_loan_payout_other + ($row_payout_shares_other['ipaid']-$row_payout_shares_other['loan']);
				
				//	$total_social_payout_other= $total_social_payout_other +(($row_payout_shares_other['savbal_balance']) > 54999 ? 0 : $row_payout_shares_other['savbal_balance']-55000);

					$total_figure_payout_other=$total_figure_payout_other +($row_payout_shares_other['vshares']+$row_payout_shares_other['ipaid']-$row_payout_shares_other['loan']);
				
				}

				echo '<tr class="balance">
							<td>Total</td>
							<td>'.number_format($total_shares_payout_other).'</td>
							<td>'.number_format($total_vshares_payout_other).' '.$_SESSION['set_cur'].'</td>
							<td>'.number_format($total_vshares_payout_other).' '.$_SESSION['set_cur'].'</td>
							<td>'.number_format($total_dividend_payout_other).' '.$_SESSION['set_cur'].'</td>
							<td>'.number_format($total_loan_payout_other).' '.$_SESSION['set_cur'].'</td>
							<td>'.number_format($total_figure_payout_other).' '.$_SESSION['set_cur'].'</td>
				</tr>';							;
				
				//Prepare LOAN Balance data for export to Excel file
				array_push($_SESSION['rep_export'], array("Type" => "Other Payout Distribution", "Amount" => $total_nvshares_payout_other));
				?>				
			</table>

				<!-- LOANS BALANCES: Table 1: Due Repayments -->
			<?PHP array_push($_SESSION['rep_export'], array("Type" => "LOAN REPAYMENTS", "Amount" => "")); ?>
			<table id="tb_table" style="width:75%">
				<colgroup>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
					<col width="10%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="7"> Loan Balances for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th> Name </th>
					<th>Loan No.</th>
					<th>Due Date</th>
					<th>Repayment Amount</th>
					<th>Loan Balance</th>
					<th>Loan Intrest</th>
					<th>Loan Type</th>
				</tr>
				<?PHP
				$testmaycleared =0;
				$total_loancleared = 0;
				while($row_loancleared = mysqli_fetch_assoc($query_loancleared)){

					$testmaycleared =$row_loancleared['loan_id'];

					$sqlcleared ="SELECT (SUM(ltrans_principal) + SUM(ltrans_interest)) AS ipaid, (SUM(ltrans_principaldue)+ SUM(ltrans_interestdue)) AS principle FROM ltrans WHERE loan_id =$testmaycleared AND ltrans_date BETWEEN $firstDay AND $lastDay ";
					$resultcleared = mysqli_query($db_link, $sqlcleared);
					$rowcleared = mysqli_fetch_assoc($resultcleared);


					echo '<tr>
									<td>'.$row_loancleared['cust_name'].'</td>
									<td><a href="loan.php?lid='.$row_loancleared['loan_id'].'">'.$row_loancleared['loan_no'].'</a></td>
									
									<td>'.date("d.m.Y",$row_loancleared['ltrans_due']).'</td>
									<td>'.number_format($row_loancleared['loan_repaytotal']).' '.$_SESSION['set_cur'].'</td>	


									<td>'.number_format($rowcleared['ipaid']-$row_loancleared['loan_repaytotal']).' '.$_SESSION['set_cur'].'</td>
									<td>'.number_format($row_loancleared['loan_interest']).'%'.'</td>
									<td>'.(number_format($row_loancleared['loan_interest']) > 0 ? "Share Loan" : "Social Fund Loan").'</td>


								</tr>';
					$total_loancleared = $total_loancleared + $rowcleared['ipaid']-$row_loancleared['loan_repaytotal'];
				}
				echo '<tr class="balance">
								<td colspan="7">Total Due Payments: '.number_format($total_loancleared).' '.$_SESSION['set_cur'].'</td>
							</tr>';
				
				//Prepare LOAN Balance data for export to Excel file
				array_push($_SESSION['rep_export'], array("Type" => "Loan Balances", "Amount" => $total_loancleared));
				?>				
			</table>


			<!-- SHARES MANAGEMENT: Table 1: Capital Additions -->
			<table id="tb_table" style="width:50%">
				<colgroup>
					<col width="50%"/>
					<col width="50%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="2">Shares Value <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Description</th>
					<th>Amount/Quantity</th>
				</tr>
				<tr>
					<td>Total Shares</td>
					<td><?PHP echo number_format($total_shares) ?></td>
				</tr>
				<tr>
					<td>Total Shares Valid for Dividends </td>
					<td><?PHP echo number_format($total_shares_payouts) ?></td>
				</tr>

				<tr class="alt">
					<td> Total Share Value</td>
					<td><?PHP echo number_format($total_share_buys).' '.$_SESSION['set_cur'] ?></td>
				</tr>

				<tr>
					<td>Total Actual Revenue</td>
					<td><?PHP echo number_format($total_share_buys + $total_incomes).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<tr>
					<td>Initial unit share value </td>
					<td><?PHP echo number_format($default_share).' '.$_SESSION['set_cur'] ?></td>
				</tr>

				<tr >
					<td>Current Unit Share value:</td>
					<td><?PHP echo number_format(($total_share_buys + $total_incomes-$total_share_sales)/$total_shares).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<tr class="balance">
					<td>Current Unit  Valid Share value:</td>
					<td><?PHP echo number_format(($total_vshares_payouts + $total_incomes)/$total_shares_payout).' '.$_SESSION['set_cur'] ?></td>
				</tr>

			</table>
			
			<!-- CAPITAL: Table 1: Capital Additions -->
			<table id="tb_table" style="width:50%">
				<colgroup>
					<col width="50%"/>
					<col width="50%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="2">Capital Additions for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Type</th>
					<th>Amount</th>
				</tr>
				<tr>
					<td>Shares Out</td>
					<td><?PHP echo number_format($total_share_buys).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<tr class="alt">
					<td>Social Fund</td>
					<td><?PHP echo number_format($total_savdep).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<tr>
					<td>Loan Recoveries</td>
					<td><?PHP echo number_format($total_loanrec).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<tr>
					<td>Other incomes </td>
					<td><?PHP echo number_format($total_incomes_others).' '.$_SESSION['set_cur'] ?></td>
				</tr>

				<tr class="balance">
					<td>Total Capital Additions:</td>
					<td><?PHP echo number_format($total_incomes_others + $total_share_buys + $total_savdep + $total_loanrec).' '.$_SESSION['set_cur'] ?></td>
				</tr>
			</table>
			
			<!-- CAPITAL: Table 2: Capital Deductions -->
			<table id="tb_table" style="width:50%">
				<colgroup>
					<col width="50%"/>
					<col width="50%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="2">Capital Deductions for <?PHP echo $rep_year; ?></th>
				</tr>
				<tr>
					<th>Type</th>
					<th>Amount</th>
				</tr>
				<tr>
					<td>Shares In</td>
					<td><?PHP echo number_format($total_share_sales).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<tr class="alt">
					<td>Loans Out</td>
					<td><?PHP echo number_format($total_loanout).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<tr>
					<td>Social Fund Withdrawals</td>
					<td><?PHP echo number_format($total_savwithd).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<tr>
					<td>Other Expenses </td>
					<td><?PHP echo number_format($total_exp).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<tr class="balance">
					<td>Total Capital Deductions:</td>
					<td><?PHP echo number_format($total_loanout+$total_savwithd+$total_exp+$total_share_sales).' '.$_SESSION['set_cur'] ?></td>
				</tr>

				</table>
				

				<!-- ACCOUNT BALANCE: Table 1:  -->
			<table id="tb_table" style="width:50%">
				<colgroup>
					<col width="50%"/>
					<col width="50%"/>
				</colgroup>
				<tr>
					<th class="title" colspan="2">Account Balance as at <?PHP echo date("d/m/").$rep_year.' '.date("h:i:sa"); ?></th>
				</tr>
				<tr>
					<th>Type</th>
					<th>Amount</th>
				</tr>
				
					<tr>
					<td>Social Fund</td>
					<td><?PHP echo number_format($total_savdep).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				
				<tr>
					<td>Share Fund</td>
					<td><?PHP echo number_format($total_incomes_others + $total_share_buys + $total_loanrec-$total_loanout-$total_savwithd-$total_exp-$total_share_sales ).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				
				<tr class="balance">
					<td>Available Balance</td>
					<td><?PHP echo number_format($total_incomes_others + $total_share_buys + $total_savdep + $total_loanrec-$total_loanout-$total_savwithd-$total_exp-$total_share_sales ).' '.$_SESSION['set_cur'] ?></td>
				</tr>
				<?PHP
				//Prepare CAPITAL data for export to Excel file
				array_push($_SESSION['rep_export'], array("Type" => "CAPITAL ADDITIONS", "Amount" => ""));
				array_push($_SESSION['rep_export'], array("Type" => "Shares Out", "Amount" => $total_share_buys));
				array_push($_SESSION['rep_export'], array("Type" => "Saving Deposits", "Amount" => $total_savdep));
				array_push($_SESSION['rep_export'], array("Type" => "Loan Recoveries", "Amount" => $total_loanrec));
				array_push($_SESSION['rep_export'], array("Type" => "Total Additions", "Amount" => $total_incomes_others+$total_loanrec+$total_savdep+$total_share_buys));
				
				array_push($_SESSION['rep_export'], array("Type" => "", "Amount" => ""));
				
				array_push($_SESSION['rep_export'], array("Type" => "CAPITAL DEDUCTIONS", "Amount" => ""));
				array_push($_SESSION['rep_export'], array("Type" => "Shares In", "Amount" => $total_share_sales));
				array_push($_SESSION['rep_export'], array("Type" => "Saving Withdrawals", "Amount" => $total_savwithd));
				array_push($_SESSION['rep_export'], array("Type" => "Loans Out", "Amount" => $total_loanout));				
				array_push($_SESSION['rep_export'], array("Type" => "Total Deductions", "Amount" => $total_loanout+$total_savwithd+$total_share_sales));
				?>
			</table>
			
		<?PHP	
		}
		?>
	</body>
</html>