<?php
// Enhanced permission checking
function checkUserPermissions($requiredPermission) {
    // Ensure session is started
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    // Check if user is logged in
    if (!isset($_SESSION['log_id'])) {
        header("Location: login.php");
        exit;
    }
    
    // Get user permissions (this should be set during login)
    $permissions = $_SESSION['user_permissions'] ?? [];
    
    // Check for permission
    if (!in_array($requiredPermission, $permissions)) {
        // Log the unauthorized access attempt
        error_log("Unauthorized access attempt by user ID: ".$_SESSION['log_id']." for feature: ".$requiredPermission);
        
        // Show user-friendly error
        $_SESSION['error'] = "You don't have permission to access this feature. Please contact your administrator.";
        header("Location: dashboard.php");
        exit;
    }
    
    return true;
}

// Permission constants
define('PERMISSION_PROCESS_PAYMENTS', 'process_payments');
define('PERMISSION_VIEW_LOANS', 'view_loans');
define('PERMISSION_MANAGE_LOANS', 'manage_loans');
?>