<?php
require 'functions.php'; // Include the same functions file used in your main script

$db_link = connect();

// Fetch financial start and end months from the date_settings table
$financialMonthsQuery = "SELECT variable_name, variable_value FROM date_settings WHERE variable_name IN ('financial_start_month', 'financial_end_month')";
$financialMonthsResult = mysqli_query($db_link, $financialMonthsQuery);

if (!$financialMonthsResult) {
    die("Failed to fetch financial months: " . mysqli_error($db_link));
}

$financialMonths = [];
while ($row = mysqli_fetch_assoc($financialMonthsResult)) {
    $financialMonths[$row['variable_name']] = (int)$row['variable_value'];
}

// Get the current year and month
$currentYear = (int)date('Y');
$currentMonth = (int)date('n');

// Calculate the financial year start and end dates
$financialStartMonth = $financialMonths['financial_start_month'];
$financialEndMonth = $financialMonths['financial_end_month'];

if ($currentMonth >= $financialStartMonth) {
    // Financial year started in the current year
    $financialStartYear = $currentYear;
    $financialEndYear = $currentYear + 1;
} else {
    // Financial year started in the previous year
    $financialStartYear = $currentYear - 1;
    $financialEndYear = $currentYear;
}

$financial_start_date = mktime(0, 0, 0, $financialStartMonth, 1, $financialStartYear);
$financial_end_date = mktime(23, 59, 59, $financialEndMonth, 31, $financialEndYear);

// Calculate the first and last day of the current month
$firstDay = mktime(0, 0, 0, $currentMonth, 1, $currentYear); // First day of the current month
$lastDay = mktime(23, 59, 59, $currentMonth, date('t', $firstDay), $currentYear); // Last day of the current month

// Fetch the company name from the settings table
$companyNameQuery = "SELECT `set_value` FROM `settings` WHERE `set_id` = 19";
$companyNameResult = mysqli_query($db_link, $companyNameQuery);
if ($companyNameResult && mysqli_num_rows($companyNameResult) > 0) {
    $companyNameRow = mysqli_fetch_assoc($companyNameResult);
    $companyName = $companyNameRow['set_value'];
} else {
    $companyName = "Dishon Eseka"; // Fallback in case the query fails
}

// Fetch the latest share value from the shareval table
$shareValueQuery = "SELECT `shareval_value` FROM `shareval` ORDER BY `shareval_date` DESC LIMIT 1";
$shareValueResult = mysqli_query($db_link, $shareValueQuery);
if ($shareValueResult && mysqli_num_rows($shareValueResult) > 0) {
    $shareValueRow = mysqli_fetch_assoc($shareValueResult);
    $shareValue = $shareValueRow['shareval_value'];
} else {
    $shareValue = 0; // Fallback in case the query fails
}

// Fetch data for the report (use the same SQL query as in your main script)
$sql = "-- Step 1: Calculate the total income for the financial period 
WITH TotalIncome AS (
    SELECT 
        IFNULL(SUM(i.inc_amount), 0) AS total_income
    FROM incomes i
    WHERE i.inc_date BETWEEN $financial_start_date AND $financial_end_date
),

-- Step 2: Calculate the total shares of eligible customers
EligibleShares AS (
    SELECT 
        IFNULL(SUM(s.share_amount), 0) AS total_shares
    FROM shares s
    JOIN customer c ON s.cust_id = c.cust_id
    WHERE 
        (SELECT IFNULL(SUM(l.loan_repaytotal), 0) FROM loans l WHERE l.cust_id = c.cust_id AND l.loan_date BETWEEN $financial_start_date AND $financial_end_date) > 2400000
        OR 
        (SELECT IFNULL(SUM(i2.inc_amount), 0) FROM incomes i2 WHERE i2.cust_id = c.cust_id AND i2.inc_date BETWEEN $financial_start_date AND $financial_end_date AND i2.inctype_id = 4) > 200000
),

-- Step 3: Calculate the share value
ShareValue AS (
    SELECT 
        (SELECT total_income FROM TotalIncome) / 
        (SELECT total_shares FROM EligibleShares) AS share_value
),

-- Step 4: Calculate PVE for each loan (WITH DATE FILTER)
LoanPVE AS (
    SELECT 
        l.cust_id,
        l.loan_id,
        IFNULL(SUM(lt.ltrans_principal + lt.ltrans_interest), 0) AS loan_paid,
        (l.loan_repaytotal / l.loan_period) AS loan_expected,
        IFNULL(
            (SUM(lt.ltrans_principal + lt.ltrans_interest) / NULLIF((l.loan_repaytotal / l.loan_period), 0)) * 100, 0
        ) AS loan_pve
    FROM loans l
    LEFT JOIN ltrans lt ON l.loan_id = lt.loan_id
    WHERE l.loanstatus_id = 2 -- Active loans
      AND lt.ltrans_date BETWEEN $firstDay AND $lastDay -- Critical fix: Filter payments to the current month
    GROUP BY l.loan_id, l.cust_id, l.loan_repaytotal, l.loan_period
),

-- Step 5: Calculate remaining installments and monthly installment for each loan (ignoring current month's payments)
LoanRemaining AS (
    SELECT 
        l.cust_id,
        l.loan_id,
        l.loan_repaytotal,
        l.loan_period,
        FROM_UNIXTIME(l.loan_date) AS loan_date, -- Convert Unix timestamp to MySQL date
        DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH) AS loan_enddate, -- Dynamically calculate loan_enddate
        GREATEST(
            (YEAR(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - YEAR(CURDATE())) * 12 + 
            (MONTH(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - MONTH(CURDATE())) + 1, 
            1
        ) AS remaining_installments, -- Ensure at least 1 installment
        (l.loan_repaytotal - IFNULL(SUM(CASE WHEN lt.ltrans_date NOT BETWEEN $firstDay AND $lastDay THEN lt.ltrans_principal + lt.ltrans_interest ELSE 0 END), 0)) AS remaining_balance, -- Exclude current month's payments
        (l.loan_repaytotal - IFNULL(SUM(CASE WHEN lt.ltrans_date NOT BETWEEN $firstDay AND $lastDay THEN lt.ltrans_principal + lt.ltrans_interest ELSE 0 END), 0)) / 
        GREATEST(
            (YEAR(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - YEAR(CURDATE())) * 12 + 
            (MONTH(DATE_ADD(FROM_UNIXTIME(l.loan_date), INTERVAL l.loan_period MONTH)) - MONTH(CURDATE())) + 1, 
            1
        ) AS monthly_installment -- Ensure at least 1 installment
    FROM loans l
    LEFT JOIN ltrans lt ON l.loan_id = lt.loan_id
    WHERE l.loanstatus_id = 2 -- Active loans
    GROUP BY l.loan_id, l.cust_id, l.loan_repaytotal, l.loan_period, l.loan_date
)

-- Step 6: Main query to fetch customer data and calculate dividends
SELECT 
    c.cust_id,
    c.cust_name,
    c.cust_group,
    c.cust_phone,
    (SELECT IFNULL(SUM(s.share_amount), 0) FROM shares s WHERE s.cust_id = c.cust_id) AS total_share,
    (SELECT IFNULL(SUM(s.share_amount), 0) FROM shares s WHERE s.cust_id = c.cust_id) * $shareValue AS total_share_value,

    -- Shares Current Month (multiplied by share value)
    (SELECT IFNULL(SUM(s.share_amount), 0) FROM shares s WHERE s.cust_id = c.cust_id AND s.share_date BETWEEN $firstDay AND $lastDay) * $shareValue AS shares_current_month,

    -- Jamii Current Month (savings deposited in the current month)
    (SELECT IFNULL(SUM(sv.sav_amount), 0) FROM savings sv WHERE sv.cust_id = c.cust_id AND sv.sav_date BETWEEN $firstDay AND $lastDay) AS jamii_current_month,

    -- Jamii Loans (0% interest)
    (SELECT IFNULL(SUM(l.loan_repaytotal / l.loan_period), 0) FROM loans l WHERE l.cust_id = c.cust_id AND l.loanstatus_id = 2 AND l.loan_interest = 0) AS jamii_expected_monthly_instalment,

    -- Normal Loans (with interest)
    (SELECT IFNULL(SUM(lr.monthly_installment), 0) FROM LoanRemaining lr WHERE lr.cust_id = c.cust_id) AS monthly_installment,
    (SELECT IFNULL(SUM(lt.ltrans_principal + lt.ltrans_interest), 0) FROM ltrans lt WHERE lt.loan_id IN (SELECT l.loan_id FROM loans l WHERE l.cust_id = c.cust_id AND l.loanstatus_id = 2 AND l.loan_interest > 0) AND lt.ltrans_date BETWEEN $firstDay AND $lastDay) AS normal_paid_monthly_instalment,

    -- Remaining Loan Balance (using LoanRemaining CTE)
    (SELECT IFNULL(SUM(lr.remaining_balance), 0) FROM LoanRemaining lr WHERE lr.cust_id = c.cust_id) AS remaining_loan_balance,

    -- PVE Percentage (Portfolio at Risk) - Loan-specific aggregation
    IFNULL(
        (SELECT AVG(loan_pve) FROM LoanPVE lp WHERE lp.cust_id = c.cust_id), 0
    ) AS pve_percentage,

    -- Share Value (from the CTE)
    (SELECT share_value FROM ShareValue) AS share_value,

    -- Dividends (shares * share value) ONLY FOR ELIGIBLE CUSTOMERS
    CASE
        WHEN 
            (SELECT IFNULL(SUM(l.loan_repaytotal), 0) FROM loans l WHERE l.cust_id = c.cust_id AND l.loan_date BETWEEN $financial_start_date AND $financial_end_date) > 2400000
            OR 
            (SELECT IFNULL(SUM(i2.inc_amount), 0) FROM incomes i2 WHERE i2.cust_id = c.cust_id AND i2.inc_date BETWEEN $financial_start_date AND $financial_end_date AND i2.inctype_id = 4) > 200000
        THEN 
            (SELECT IFNULL(SUM(s.share_amount), 0) FROM shares s WHERE s.cust_id = c.cust_id) * (SELECT share_value FROM ShareValue)
        ELSE 
            0
    END AS dividends
FROM 
    customer c
LEFT JOIN 
    LoanPVE lp ON c.cust_id = lp.cust_id
LEFT JOIN 
    LoanRemaining lr ON c.cust_id = lr.cust_id
WHERE 
    c.cust_group IS NOT NULL -- Exclude members with NULL group values
GROUP BY 
    c.cust_id
ORDER BY 
    c.cust_group, c.cust_name;";

$query = mysqli_query($db_link, $sql);
checkSQL($db_link, $query);

// SMS Gateway credentials
$username = "LMXGCL"; // Replace with your SMS gateway username
$password = "v7uvnnhfhaqzpy"; // Replace with your SMS gateway password

// Encode credentials for Basic Authentication
$credentials = base64_encode("$username:$password");

// Loop through each customer and send SMS
while ($row = mysqli_fetch_assoc($query)) {
    $customerName = $row['cust_name'];
    $customerPhone = $row['cust_phone'];
    $totalShare = number_format($row['total_share'], 2);
    $totalShareValue = number_format($row['total_share_value'], 2);
    $sharesCurrentMonth = number_format($row['shares_current_month'], 2);
    $jamiiCurrentMonth = number_format($row['jamii_current_month'], 2);
    $jamiiExpectedMonthlyInstalment = number_format($row['jamii_expected_monthly_instalment'], 2);
    $monthlyInstallment = number_format($row['monthly_installment']-$row['jamii_expected_monthly_instalment'], 2);
    $normalPaidMonthlyInstalment = number_format($row['normal_paid_monthly_instalment'], 2);
    $remainingLoanBalance = number_format($row['remaining_loan_balance']-$row['normal_paid_monthly_instalment'], 2);
    $pvePercentage = number_format($row['pve_percentage'], 2);
    $dividends = number_format($row['dividends'], 2);

    // Prepare the SMS content
    $smsContent = "Hello $customerName,\n";
    $smsContent .= "Your monthly current report details as at " . date('F Y', $firstDay) . ":\n";
    $smsContent .= "Total Share: $totalShare \n";
    $smsContent .= "Total Share Value: $totalShareValue TSH\n";
    $smsContent .= "Shares Current Month: $sharesCurrentMonth TSH\n";
    $smsContent .= "Jamii Current Month: $jamiiCurrentMonth TSH\n";
    $smsContent .= "Jamii Expected Monthly Instalment: $jamiiExpectedMonthlyInstalment TSH\n";
    $smsContent .= "Loan Monthly Instalment: $monthlyInstallment TSH\n";
    $smsContent .= "Loan Paid Monthly Instalment: $normalPaidMonthlyInstalment TSH\n";
    $smsContent .= "Remaining Loan Balance: $remainingLoanBalance TSH\n";
    $smsContent .= "Dividends: $dividends TSH \n";
    $smsContent .= "Thank you for being a valued member of $companyName.";

    // SMS data for the new gateway
    $smsData = [
        'isEncrypted' => false,
        'message' => $smsContent,
        'phoneNumbers' => ["+$customerPhone"], // Ensure the phone number starts with +
        'simNumber' => 2,
        'withDeliveryReport' => true
    ];

    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.sms-gate.app/3rdparty/v1/messages?skipPhoneValidation=false");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($smsData)); // Send JSON data
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true); // Enable SSL verification
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2); // Verify the host

    // Set headers
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'accept: application/json',
        'authorization: Basic ' . $credentials,
        'Content-Type: application/json'
    ]);

    // Execute the request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Decode the JSON response
    $responseData = json_decode($response, true);

    // Check for errors
    if (curl_errno($ch)) {
        echo "Error sending SMS to $customerName (+$customerPhone): " . curl_error($ch) . "\n";
    } else {
        echo "SMS sent to $customerName (+$customerPhone): HTTP Status Code: $httpCode, Response: $response\n";

        // Insert SMS details into the sms_messages table if the SMS was accepted
        if ($httpCode == 202) {
            $gateway_id = $responseData['id']; // Get the gateway ID from the response
            $sms_status = 'pending'; // Set status to pending
            $sms_direction = 'out'; // Since this is an outgoing SMS

            // Convert Unix timestamp to EAT (UTC+3)
            $eat_timestamp = date('Y-m-d H:i:s', time() + (3 * 3600)); // Add 3 hours for EAT

            // Insert into sms_messages table
            $sql_insert_sms = "INSERT INTO sms_messages (id, type, phone_number, message, timestamp, status, direction) 
                               VALUES ('$gateway_id', 'outbound', '+$customerPhone', '$smsContent', '$eat_timestamp', '$sms_status', '$sms_direction')";

            $query_insert_sms = mysqli_query($db_link, $sql_insert_sms);

            if (!$query_insert_sms) {
                echo "Failed to insert SMS into sms_messages table: " . mysqli_error($db_link) . "\n";
            } else {
                echo "SMS details inserted into sms_messages table with gateway_id: $gateway_id\n";
            }
        }
    }

    // Close cURL
    curl_close($ch);

    // Introduce a 5-second delay before sending the next SMS
    sleep(5);
}

mysqli_close($db_link);
?>