<?php
class SmsService {
    protected $db;
    
    public function __construct($db) {
        $this->db = $db;
    }
    
    public function createPaymentNotification($customerName, $loanNo, $amountPaid, $principalPaid, $interestPaid, $remainingAmount, $isFullyPaid) {
        $message = "Dear $customerName,\n";
        $message .= "Your payment of " . number_format($amountPaid, 2) . " TSH for loan $loanNo has been processed.\n";
        $message .= "Principal: " . number_format($principalPaid, 2) . " TSH\n";
        $message .= "Interest: " . number_format($interestPaid, 2) . " TSH\n";
        
        if ($remainingAmount > 0) {
            if ($isFullyPaid) {
                $message .= "Excess amount: " . number_format($remainingAmount, 2) . " TSH will be returned to you.\n";
            } else {
                $message .= "Note: " . number_format($remainingAmount, 2) . " TSH was not applied (not enough for next installment).\n";
            }
        }
        
        if ($isFullyPaid) {
            $message .= "Your loan is now fully paid. Thank you!\n";
        } else {
            $balance = $principalPaid + $interestPaid + $remainingAmount - $amountPaid;
            $message .= "Remaining balance: " . number_format($balance, 2) . " TSH\n";
        }
        
        $message .= $_SESSION['company_name'];
        return $message;
    }
    
    public function sendSMS($phoneNumber, $message) {
        // Implement actual SMS gateway integration here
        // This is a mock implementation
        $stmt = $this->db->prepare("
            INSERT INTO sms_queue 
            (phone_number, message, status, created_at) 
            VALUES (?, ?, 'pending', UNIX_TIMESTAMP())
        ");
        $stmt->bind_param("ss", $phoneNumber, $message);
        $stmt->execute();
        
        // Log the SMS
        $this->logSMS($phoneNumber, $message);
        
        return true;
    }
    
    protected function logSMS($phoneNumber, $message) {
        $stmt = $this->db->prepare("
            INSERT INTO sms_logs 
            (user_id, phone_number, message, sent_at) 
            VALUES (?, ?, ?, UNIX_TIMESTAMP())
        ");
        $stmt->bind_param("iss", $_SESSION['log_id'], $phoneNumber, $message);
        $stmt->execute();
    }
}
?>